
<?php $__env->startSection('title'); ?>
<title><?php echo e($title_meta->home_title); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta'); ?>
<meta name="description" content="<?php echo e($title_meta->home_meta_description); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('client-content'); ?>

<!--Slider Start-->
<div class="slider" id="main-slider">

    <div class="doc-search-item">
        <?php
            $sliderContent=App\Setting::first();
        ?>
        <div class="d-flex align-items-center h_100_p">
            <div class="v-mid-content">
                <div class="heading">
                    <h2><?php echo e($sliderContent->slider_heading); ?></h2>
                    <p><?php echo e($sliderContent->slider_description); ?></p>
                </div>
                <div class="doc-search-section">
                    <form action="<?php echo e(url('search-lawyer')); ?>">
                    <div class="box">
                        <select name="location" class="form-control select2">
                            <option value=""><?php echo e($website_lang->where('lang_key','select_location')->first()->custom_lang); ?></option>
                            <?php $__currentLoopData = $locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $location): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option <?php echo e(@$location_id==$location->id?'selected':''); ?> value="<?php echo e($location->id); ?>"><?php echo e(ucwords($location->location)); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="box">
                        <select name="department" class="form-control select2">
                            <option value=""><?php echo e($website_lang->where('lang_key','select_department')->first()->custom_lang); ?></option>
                            <?php $__currentLoopData = $departmentsForSearch; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option <?php echo e(@$department_id==$department->id?'selected':''); ?> value="<?php echo e($department->id); ?>"><?php echo e(ucwords($department->name)); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="box">
                        <select name="lawyer" class="form-control select2">
                            <option value=""><?php echo e($website_lang->where('lang_key','select_lawyer')->first()->custom_lang); ?></option>
                            <?php $__currentLoopData = $lawyersForSearch; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lawyer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($lawyer->id); ?>"><?php echo e($lawyer->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="doc-search-button">
                        <button type="submit" class="btn btn-danger"><?php echo e($website_lang->where('lang_key','search')->first()->custom_lang); ?></button>
                    </div>
                </form>
                </div>

            </div>
        </div>




    </div>




    <div class="slide-carousel owl-carousel">
        <?php $__currentLoopData = $sliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="slider-item flex" style="background-image:url(<?php echo e(url($item->image)); ?>);">
            <div class="bg-slider"></div>
            <div class="container">
                <div class="row">

                </div>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


    </div>
</div>
<!--Slider End-->





<?php
    $feature_section=$homesections->where('section_type',1)->first();
?>
<!--Why Us Start-->
<?php if($feature_section->show_homepage==1): ?>
<div class="why-us-area pt_30">
    <div class="container">
        <div class="row">
            <?php $__currentLoopData = $features->take($feature_section->content_quantity); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-lg-4 choose-col">
                <div class="choose-item flex" style="background-image: url(<?php echo e(url($feature->background_image)); ?>)">
                    <div class="choose-icon">
                        <i class="<?php echo e($feature->logo); ?>"></i>
                    </div>
                    <div class="choose-text">
                        <h4><?php echo e($feature->title); ?></h4>
                        <p>
                           <?php echo e($feature->description); ?>

                        </p>
                    </div>
                </div>
            </div>

            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </div>
    </div>
</div>
<!--why Us End-->
<?php endif; ?>

<?php
    $work_section=$homesections->where('section_type',2)->first();
?>
<?php if($work_section->show_homepage==1): ?>
<!--Feature Start-->
<div class="about-area">
    <div class="container">
        <div class="row ov_hd">
            <div class="col-md-12 wow fadeInDown">
                <div class="main-headline">
                    <h1><span><?php echo e(ucfirst($work_section->first_header)); ?></span> <?php echo e(ucfirst($work_section->second_header)); ?></h1>
                    <p><?php echo e($work_section->description); ?></p>
                </div>
            </div>
        </div>
    </div>
    <div class="coustom-container">
        <div class="row ov_hd">
            <div class="col-lg-6 wow fadeInLeft" data-wow-delay="0.2s">
                <div class="about-skey mt_50">
                    <div class="about-img">
                        <img src="<?php echo e($work->image ? url($work->image) : ''); ?>" alt="">
                        <div class="video-section video-section-home">
                            <a class="video-button mgVideo" href="<?php echo e($work->video); ?>"><span></span></a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6 wow fadeInRight" data-wow-delay="0.2s">
                <div class="feature-section-text mt_50">
                    <h2><?php echo e($work->title); ?></h2>
                    <p><?php echo e($work->description); ?></p>
                    <div class="feature-accordion" id="accordion">
                        <?php $__currentLoopData = $workFaqs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $faqIndex => $faq): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="faq-item card">
                            <div class="faq-header" id="heading1-<?php echo e($faq->id); ?>">
                                <button class="faq-button <?php echo e($faqIndex != 0 ? 'collapsed':''); ?>" data-toggle="collapse" data-target="#collapse1-<?php echo e($faq->id); ?>" aria-expanded="true" aria-controls="collapse1-<?php echo e($faq->id); ?>"><?php echo e($faq->question); ?></button>
                            </div>

                            <div id="collapse1-<?php echo e($faq->id); ?>" class="collapse <?php echo e($faqIndex == 0 ? 'show':''); ?>" aria-labelledby="heading1-<?php echo e($faq->id); ?>" data-parent="#accordion">
                                <div class="faq-body">
                                   <?php echo clean($faq->answer); ?>

                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!--Feature End-->
<?php endif; ?>

<?php
$service_section=$homesections->where('section_type',3)->first();
?>
<?php if($service_section->show_homepage==1): ?>
<!--Service Start-->
<div class="service-area bg-area">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="main-headline">
                    <h1><span><?php echo e(ucfirst($service_section->first_header)); ?></span> <?php echo e(ucfirst($service_section->second_header)); ?></h1>
                    <p><?php echo e($service_section->description); ?></p>
                </div>
            </div>
        </div>
        <div class="row service-row">
            <div class="col-md-12">
                <div class="service-coloum-area">
                    <?php $__currentLoopData = $services->take($service_section->content_quantity); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="service-coloum">
                        <div class="service-item">
                            <i class="<?php echo e($service->icon); ?>"></i>
                            <h3><?php echo e($service->header); ?></h3>
                            <p><?php echo e($service->sort_description); ?></p>

                            <?php if($isRtl=='RTL'): ?>
                            <a href="<?php echo e(url('service-details/'.$service->slug)); ?>"><?php echo e($website_lang->where('lang_key','learn_more')->first()->custom_lang); ?> ←</a>
                            <?php else: ?>
                            <a href="<?php echo e(url('service-details/'.$service->slug)); ?>"><?php echo e($website_lang->where('lang_key','learn_more')->first()->custom_lang); ?> →</a>
                            <?php endif; ?>

                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="home-button ser-btn">
                    <a href="<?php echo e(url('service')); ?>"><?php echo e($website_lang->where('lang_key','all_service')->first()->custom_lang); ?></a>
                </div>
            </div>
        </div>
        <!--Counter Start-->

        <div class="counter-row row" style="background-image: url(<?php echo e($banner->overview ? url($banner->overview) : ''); ?>)">
            <?php $__currentLoopData = $overviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $overview): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-lg-3 col-6 mt_30 wow fadeInDown" data-wow-delay="0.2s">
                <div class="counter-item">
                    <div class="counter-icon">
                        <i class="<?php echo e($overview->icon); ?>"></i>
                    </div>
                    <h2 class="counter"><?php echo e($overview->qty); ?></h2>
                    <h4><?php echo e($overview->name); ?></h4>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </div>
        <!--Counter End-->
    </div>
</div>
<!--Service End-->
<?php endif; ?>


<?php
$department_section=$homesections->where('section_type',4)->first();
?>
<?php if($department_section->show_homepage==1): ?>
<!--Portfolio Start-->
<div class="case-study-home-page case-study-area ">
    <div class="container">
        <div class="row mb_25">
            <div class="col-md-12 wow fadeInDown" data-wow-delay="0.1s">
                <div class="main-headline">
                    <h1><span><?php echo e(ucfirst($department_section->first_header)); ?></span> <?php echo e(ucfirst($department_section->second_header)); ?></h1>
                    <p><?php echo e($department_section->description); ?></p>
                </div>
            </div>
        </div>
        <div class="row">
            <?php $__currentLoopData = $departments->take($department_section->content_quantity); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-lg-4 col-md-6 mt_15">
                        <div class="case-item">
                            <div class="case-box">
                                <div class="case-image">
                                    <img src="<?php echo e(url($department->thumbnail_image)); ?>" alt="">
                                    <div class="overlay"><a href="<?php echo e(url('department-details/'.$department->slug)); ?>" class="btn-case"><?php echo e($website_lang->where('lang_key','see_details')->first()->custom_lang); ?></a>
                                    </div>
                                </div>
                                <div class="case-content">
                                    <h4><a href="<?php echo e(url('department-details/'.$department->slug)); ?>"><?php echo e($department->name); ?></a></h4>
                                </div>
                            </div>
                        </div>
                    </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <div class="row mb_60">
            <div class="col-md-12">
                <div class="home-button">
                    <a href="<?php echo e(url('department')); ?>"><?php echo e($website_lang->where('lang_key','all_department')->first()->custom_lang); ?></a>
                </div>
            </div>
        </div>
    </div>
</div>

<?php endif; ?>


<?php
$patient_section=$homesections->where('section_type',5)->first();
?>
<?php if($patient_section->show_homepage==1): ?>
<!--Testimonial Start-->
<div class="testimonial-area <?php echo e($department_section->show_homepage==0 ? 'mt_200':''); ?>">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="main-headline">
                    <h1><span><?php echo e(ucfirst($patient_section->first_header)); ?></span> <?php echo e(ucfirst($patient_section->second_header)); ?></h1>
                    <p><?php echo e($patient_section->description); ?></p>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="testimonial-texarea mt_30">
                    <div class="owl-testimonial owl-carousel">
                        <?php $__currentLoopData = $testimonials->take($patient_section->content_quantity); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $patient): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="testimonial-item wow fadeIn" data-wow-delay="0.2s">
                            <p class="wow fadeInDown" data-wow-delay="0.2s">
                                <?php echo e($patient->description); ?>

                            </p>
                            <div class="testi-info wow fadeInUp" data-wow-delay="0.2s">
                                <img src="<?php echo e(url($patient->image)); ?>" alt="">
                                <h4><?php echo e($patient->name); ?></h4>
                                <span><?php echo e($patient->designation); ?></span>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!--Testimonial End-->
<?php endif; ?>



<?php
$lawyer_section=$homesections->where('section_type',6)->first();
?>
<?php if($lawyer_section->show_homepage==1): ?>
<!--Team Area Start-->
<div class="team-area">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="main-headline">
                    <h1><span><?php echo e(ucfirst($lawyer_section->first_header)); ?></span> <?php echo e(ucfirst($lawyer_section->second_header)); ?></h1>
                    <p><?php echo e($lawyer_section->description); ?></p>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="team-carousel owl-carousel">
                    <?php $__currentLoopData = $lawyers->take($lawyer_section->content_quantity); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lawyer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="team-item">
                        <div class="team-photo">
                            <img src="<?php echo e(url($lawyer->image)); ?>" alt="Team Photo">
                        </div>
                        <div class="team-text">
                            <a href="<?php echo e(url('lawyer-details/'.$lawyer->slug)); ?>"><?php echo e($lawyer->name); ?></a>
                            <p><?php echo e($lawyer->department->name); ?></p>
                            <p><span><i class="fas fa-graduation-cap"></i> <?php echo e($lawyer->designations); ?></span></p>
                            <p><span><b><i class="fas fa-street-view"></i> <?php echo e(ucfirst($lawyer->location->location)); ?></b></span></p>
                        </div>
                        <div class="team-social">
                            <ul>
                                <?php if($lawyer->facebook): ?>
                                <li><a href="<?php echo e($lawyer->facebook); ?>"><i class="fab fa-facebook-f"></i></a></li>
                                <?php endif; ?>
                                <?php if($lawyer->twitter): ?>
                                <li><a href="<?php echo e($lawyer->twitter); ?>"><i class="fab fa-twitter"></i></a></li>
                                <?php endif; ?>
                                <?php if($lawyer->linkedin): ?>
                                <li><a href="<?php echo e($lawyer->linkedin); ?>"><i class="fab fa-linkedin"></i></a></li>
                                <?php endif; ?>
                            </ul>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                </div>
            </div>
        </div>
    </div>
</div>
<!--Team Area End-->
<?php endif; ?>


<?php
$blog_section=$homesections->where('section_type',7)->first();
?>
<?php if($blog_count !=0): ?>
<?php if($blog_section->show_homepage==1): ?>
<!--Blog-Area Start-->
<div class="blog-area bg_ecf1f8">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="main-headline">
                    <h1><span><?php echo e(ucfirst($blog_section->first_header)); ?></span> <?php echo e(ucfirst($blog_section->second_header)); ?></h1>
                    <p><?php echo e($blog_section->description); ?></p>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-6">
                <div class="blog-item first-blog">
                    <a href="<?php echo e(url($feature_blog->feature_image)); ?>" class="image-effect">
                        <div class="blog-image">
                            <img src="<?php echo e(url($feature_blog->feature_image)); ?>" alt="">
                        </div>
                    </a>
                    <div class="blog-text">
                        <div class="blog-author">
                            <span><i class="fas fa-user"></i> <?php echo e($website_lang->where('lang_key','admin')->first()->custom_lang); ?></span>
                            <span><i class="far fa-calendar-alt"></i> <?php echo e($feature_blog->created_at->format('m-d-Y')); ?></span>
                        </div>
                        <h3><a href="<?php echo e(url('blog-details/'.$feature_blog->slug)); ?>"><?php echo e($feature_blog->title); ?></a></h3>
                        <p>
                            <?php echo e($feature_blog->sort_description); ?>

                        </p>

                        <?php if($isRtl=='RTL'): ?>
                        <a class="sm_btn" href="<?php echo e(url('blog-details/'.$feature_blog->slug)); ?>"><?php echo e($website_lang->where('lang_key','see_details')->first()->custom_lang); ?> ←</a>
                        <?php else: ?>
                            <a class="sm_btn" href="<?php echo e(url('blog-details/'.$feature_blog->slug)); ?>"><?php echo e($website_lang->where('lang_key','see_details')->first()->custom_lang); ?> →</a>
                        <?php endif; ?>


                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="blog-carousel owl-carousel">
                    <?php $i=0; ?>
                    <?php $__currentLoopData = $blogs->take($blog_section->content_quantity); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php $i++; ?>
                        <?php if($i == 1): ?>
                            <?php continue; ?>
                        <?php endif; ?>
                        <div class="blog-item effect-item">
                            <a href="#" class="image-effect">
                                <div class="blog-image">
                                    <img src="<?php echo e($blog->thumbnail_image); ?>" alt="Blog Thumbnail Image">
                                </div>
                            </a>
                            <div class="blog-text">
                                <div class="blog-author">
                                    <span><i class="fas fa-user"></i> <?php echo e($website_lang->where('lang_key','admin')->first()->custom_lang); ?></span>
                                    <span><i class="far fa-calendar-alt"></i> <?php echo e($blog->created_at->format('m-d-Y')); ?></span>
                                </div>
                                <h3><a href="<?php echo e(url('blog-details/'.$blog->slug)); ?>"><?php echo e($blog->title); ?></a></h3>
                                <p>
                                    <?php echo e($blog->sort_description); ?>

                                </p>

                                <?php if($isRtl=='RTL'): ?>
                                <a class="sm_btn" href="<?php echo e(url('blog-details/'.$blog->slug)); ?>"><?php echo e($website_lang->where('lang_key','see_details')->first()->custom_lang); ?> ←</a>
                                <?php else: ?>
                                <a class="sm_btn" href="<?php echo e(url('blog-details/'.$blog->slug)); ?>"><?php echo e($website_lang->where('lang_key','see_details')->first()->custom_lang); ?> →</a>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                </div>
            </div>
        </div>
    </div>
</div>
<!--Blog-Area End-->
<?php endif; ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.client.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\wsus-cc\4_lawment_ibrahim\script_content\main_files\resources\views/client/index.blade.php ENDPATH**/ ?>