<?php

namespace App;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    use Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name','email','image','phone','address','city','country','guardian_name','guardian_phone','health_insurance_number','health_card_number','health_card_provider','occupation','age','date_of_birth','gender','weight','height','blood_group','disabilities','email_verified_token','password','status','forget_password_token','email_verified','ready_for_appointment','patient_id'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function appointment(){
        return $this->hasMany(Appointment::class);
    }
}
