
<?php $__env->startSection('title'); ?>
<title><?php echo e($website_lang->where('lang_key','work_faq')->first()->custom_lang); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
    <h1 class="h3 mb-2 text-gray-800"><a href="#" data-toggle="modal" data-target="#addFaq" class="btn btn-success"><i class="fas fa-plus" aria-hidden="true"></i> <?php echo e($website_lang->where('lang_key','new_faq')->first()->custom_lang); ?> </a></h1>

    <!-- DataTales Example -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary"><?php echo e($website_lang->where('lang_key','faq_table')->first()->custom_lang); ?>

            </h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th width="5%"><?php echo e($website_lang->where('lang_key','serial')->first()->custom_lang); ?></th>
                            <th width="30%"><?php echo e($website_lang->where('lang_key','qus')->first()->custom_lang); ?></th>
                            <th width="45%"><?php echo e($website_lang->where('lang_key','ans')->first()->custom_lang); ?></th>
                            <th width="10%"><?php echo e($website_lang->where('lang_key','status')->first()->custom_lang); ?></th>
                            <th width="10%"><?php echo e($website_lang->where('lang_key','action')->first()->custom_lang); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $faqs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e(++$index); ?></td>
                            <td><?php echo e($item->question); ?></td>
                            <td><?php echo clean($item->answer); ?></td>
                            <td>
                                <?php if($item->status==1): ?>
                                    <a href="" onclick="faqStatus(<?php echo e($item->id); ?>)"><input type="checkbox" checked data-toggle="toggle" data-on="<?php echo e($website_lang->where('lang_key','active')->first()->custom_lang); ?>" data-off="<?php echo e($website_lang->where('lang_key','inactive')->first()->custom_lang); ?>" data-onstyle="success" data-offstyle="danger"></a>
                                <?php else: ?>
                                    <a href="" onclick="faqStatus(<?php echo e($item->id); ?>)"><input type="checkbox" data-toggle="toggle" data-on="<?php echo e($website_lang->where('lang_key','active')->first()->custom_lang); ?>" data-off="<?php echo e($website_lang->where('lang_key','inactive')->first()->custom_lang); ?>" data-onstyle="success" data-offstyle="danger"></a>

                                <?php endif; ?>
                            </td>
                            <td>
                                <a href="#" data-toggle="modal" data-target="#updateFaq-<?php echo e($item->id); ?>" class="btn btn-primary btn-sm"><i class="fas fa-edit"></i></a>
                                <a data-toggle="modal" data-target="#deleteModal" href="javascript:;" onclick="deleteData(<?php echo e($item->id); ?>)" class="btn btn-danger btn-sm"><i class="fas fa-trash    "></i></a>


                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- create new Faq Modal -->
    <div class="modal fade" id="addFaq" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                    <div class="modal-header">
                            <h5 class="modal-title"><?php echo e($website_lang->where('lang_key','faq_form')->first()->custom_lang); ?></h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                        </div>
                <div class="modal-body">
                    <div class="container-fluid">
                    <form action="<?php echo e(route('admin.work-faq.store')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="form-group">
                            <label for="question"><?php echo e($website_lang->where('lang_key','qus')->first()->custom_lang); ?></label>
                            <input type="text" class="form-control" name="question" id="question" value="<?php echo e(old('question')); ?>" placeholder="Type Faq Question...">


                        </div>
                        <div class="form-group">
                            <label for="answer"><?php echo e($website_lang->where('lang_key','ans')->first()->custom_lang); ?></label>
                            <textarea class="summernote" id="answer" name="answer"><?php echo e(old('answer')); ?></textarea>

                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="status"><?php echo e($website_lang->where('lang_key','status')->first()->custom_lang); ?></label>
                                    <select name="status" id="status" class="form-control">
                                        <option value="1"><?php echo e($website_lang->where('lang_key','active')->first()->custom_lang); ?></option>
                                        <option value="0"><?php echo e($website_lang->where('lang_key','inactive')->first()->custom_lang); ?></option>
                                    </select>
                                </div>
                            </div>
                        </div>


                        <button type="button" class="btn btn-danger" data-dismiss="modal"><?php echo e($website_lang->where('lang_key','close')->first()->custom_lang); ?></button>
                        <button type="submit" class="btn btn-success"><?php echo e($website_lang->where('lang_key','save')->first()->custom_lang); ?></button>
                    </form>
                    </div>
                </div>

            </div>
        </div>
    </div>

     <!-- update new Faq Modal -->
     <?php $__currentLoopData = $faqs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="modal fade" id="updateFaq-<?php echo e($item->id); ?>" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                    <div class="modal-header">
                            <h5 class="modal-title"><?php echo e($website_lang->where('lang_key','faq_form')->first()->custom_lang); ?></h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                        </div>
                <div class="modal-body">
                    <div class="container-fluid">
                    <form action="<?php echo e(route('admin.work-faq.update',$item->id)); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('patch'); ?>
                        <div class="form-group">
                            <label for="question"><?php echo e($website_lang->where('lang_key','qus')->first()->custom_lang); ?></label>
                            <input type="text" class="form-control" name="question" id="question" value="<?php echo e($item->question); ?>">

                        </div>
                        <div class="form-group">
                            <label for="answer"><?php echo e($website_lang->where('lang_key','ans')->first()->custom_lang); ?></label>
                            <textarea class="summernote" id="answer" name="answer"><?php echo e($item->answer); ?></textarea>

                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="status"><?php echo e($website_lang->where('lang_key','status')->first()->custom_lang); ?></label>
                                    <select name="status" id="status" class="form-control">
                                        <option <?php echo e($item->status==1 ? 'selected':''); ?> value="1"><?php echo e($website_lang->where('lang_key','active')->first()->custom_lang); ?></option>
                                        <option <?php echo e($item->status==0 ? 'selected':''); ?> value="0"><?php echo e($website_lang->where('lang_key','inactive')->first()->custom_lang); ?></option>
                                    </select>
                                </div>
                            </div>
                        </div>


                        <button type="button" class="btn btn-danger" data-dismiss="modal"><?php echo e($website_lang->where('lang_key','close')->first()->custom_lang); ?></button>
                        <button type="submit" class="btn btn-success"><?php echo e($website_lang->where('lang_key','update')->first()->custom_lang); ?></button>
                    </form>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



    <script>
        function deleteData(id){
            $("#deleteForm").attr("action",'<?php echo e(url("/admin/work-faq/")); ?>'+"/"+id)
        }

        function faqStatus(id){

// project demo mode check
         var isDemo="<?php echo e(env('PROJECT_MODE')); ?>"
         var demoNotify="<?php echo e(env('NOTIFY_TEXT')); ?>"
         if(isDemo==0){
             toastr.error(demoNotify);
             return;
         }
         // end
            $.ajax({
                type:"get",
                url:"<?php echo e(url('/admin/work-faq-status/')); ?>"+"/"+id,
                success:function(response){
                   toastr.success(response)
                },
                error:function(err){
                    console.log(err);

                }
            })
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/penastud/public_html/law/resources/views/admin/work/faq/index.blade.php ENDPATH**/ ?>