
<?php $__env->startSection('title'); ?>
<title><?php echo e($website_lang->where('lang_key','zoom_meeting')->first()->custom_lang); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('lawyer-content'); ?>
    <!-- Page Heading -->
    <h1 class="h3 mb-2 text-gray-800"><a href="<?php echo e(route('lawyer.create-zoom-meeting')); ?>" class="btn btn-primary"><i class="fas fa-plus" aria-hidden="true"></i> <?php echo e($website_lang->where('lang_key','create')->first()->custom_lang); ?> </a></h1>
    <!-- DataTales Example -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary"><?php echo e($website_lang->where('lang_key','meeting_table')->first()->custom_lang); ?></h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th ><?php echo e($website_lang->where('lang_key','serial')->first()->custom_lang); ?></th>
                            <th ><?php echo e($website_lang->where('lang_key','start_time')->first()->custom_lang); ?></th>
                            <th ><?php echo e($website_lang->where('lang_key','duration')->first()->custom_lang); ?></th>
                            <th ><?php echo e($website_lang->where('lang_key','meeting_id')->first()->custom_lang); ?></th>
                            <th><?php echo e($website_lang->where('lang_key','password')->first()->custom_lang); ?></th>
                            <th><?php echo e($website_lang->where('lang_key','action')->first()->custom_lang); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $meetings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $meeting): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e(++$index); ?></td>
                            <td><?php echo e(date('Y-m-d h:i:A',strtotime($meeting->start_time))); ?></td>
                            <td><?php echo e($meeting->duration); ?> <?php echo e($website_lang->where('lang_key','minute')->first()->custom_lang); ?></td>
                            <td><?php echo e($meeting->meeting_id); ?></td>
                            <td><?php echo e($meeting->password); ?></td>

                            <td>
                                <?php if(env('PROJECT_MODE')==0): ?>
                                    <a id="zoom_demo_mode" href="javascript:;"  class="btn btn-success btn-sm"><i class="fas fa-video"></i></a>
                                <?php else: ?>
                                <a target="_blank" href="<?php echo e($meeting->join_url); ?>" class="btn btn-success btn-sm"><i class="fas fa-video"></i></a>
                                <?php endif; ?>

                                <a href="<?php echo e(route('lawyer.edit-zoom-meeting',$meeting->id)); ?>" class="btn btn-primary btn-sm"><i class="fas fa-edit"></i></a>
                                <a onclick="return confirm('<?php echo e($website_lang->where('lang_key','are_you_sure')->first()->custom_lang); ?>')" href="<?php echo e(route('lawyer.delete-zoom-meeting',$meeting->id)); ?>" class="btn btn-danger btn-sm"><i class="fas fa-trash"></i></a>




                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <script>
        (function($) {
        "use strict";
        $(document).ready(function () {
            $(document).on('click', '#zoom_demo_mode', function () {
                var demoNotify="<?php echo e(env('NOTIFY_TEXT')); ?>"
                toastr.error(demoNotify);
            });
        });
        })(jQuery);

        </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.lawyer.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/penastud/public_html/law/resources/views/lawyer/zoom/meeting/index.blade.php ENDPATH**/ ?>