
<?php $__env->startSection('title'); ?>
<title><?php echo e($title_meta->department_title); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta'); ?>
<meta name="description" content="<?php echo e($title_meta->department_meta_description); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('client-content'); ?>

<!--Banner Start-->
<div class="banner-area flex" style="background-image:url(<?php echo e($banner->department ? url($banner->department) : ''); ?>);">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="banner-text">
                    <h1><?php echo e($navigation->department); ?></h1>
                    <ul>
                        <li><a href="<?php echo e(url('/')); ?>"><?php echo e($navigation->home); ?></a></li>
                        <li><span><?php echo e($navigation->department); ?></span></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
<!--Banner End-->

<div class="case-study-home-page case-study-area pt_50">
    <div class="container">
        <div class="row">
            <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-lg-4 col-md-6 mt_15">
                <div class="case-item">
                    <div class="case-box">
                        <div class="case-image">
                            <img src="<?php echo e($department->thumbnail_image); ?>" alt="">
                            <div class="overlay"><a href="<?php echo e(url('department-details/'.$department->slug)); ?>" class="btn-case"><?php echo e($website_lang->where('lang_key','see_details')->first()->custom_lang); ?></a>
                            </div>
                        </div>
                        <div class="case-content">
                            <h4><a href="<?php echo e(url('department-details/'.$department->slug)); ?>"><?php echo e($department->name); ?></a></h4>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



        </div>
        <div class="mb-5">
            <?php echo e($departments->links('client.paginator')); ?>

        </div>

    </div>
</div>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.client.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/penastud/public_html/law/resources/views/client/department/index.blade.php ENDPATH**/ ?>