
<?php $__env->startSection('title'); ?>
<title><?php echo e($website_lang->where('lang_key','appointment_list')->first()->custom_lang); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('client-content'); ?>


<!--Banner Start-->
<div class="banner-area flex" style="background-image:url(<?php echo e($banner->profile ? url($banner->profile) : ''); ?>);">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="banner-text">
                    <h1><?php echo e($website_lang->where('lang_key','appointment_list')->first()->custom_lang); ?></h1>
                    <ul>
                        <li><a href="<?php echo e(url('/')); ?>"><?php echo e($navigation->home); ?></a></li>
                        <li><span><?php echo e($website_lang->where('lang_key','appointment_list')->first()->custom_lang); ?></span></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
<!--Banner End-->

<!--Dashboard Start-->
<div class="dashboard-area pt_70 pb_70">
    <div class="container">
        <div class="row">
            <div class="col-lg-3">
                <?php echo $__env->make('client.profile.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-lg-9">
                <div class="detail-dashboard">
                <h2 class="d-headline"><?php echo e($website_lang->where('lang_key','appointment_list')->first()->custom_lang); ?></h2>
                <div class="table-responsive">
                <table class="coustom-dashboard dashboard-table display" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <th  width="3%"><?php echo e($website_lang->where('lang_key','serial')->first()->custom_lang); ?></th>
                                <th  width="15%"><?php echo e($website_lang->where('lang_key','lawyer')->first()->custom_lang); ?></th>
                                <th  width="20%"><?php echo e($website_lang->where('lang_key','date')->first()->custom_lang); ?></th>
                                <th  width="10%"><?php echo e($website_lang->where('lang_key','appointment_fee')->first()->custom_lang); ?></th>
                                <th  width="30%"><?php echo e($website_lang->where('lang_key','schedule')->first()->custom_lang); ?></th>
                                <th  width="10%"><?php echo e($website_lang->where('lang_key','payment')->first()->custom_lang); ?></th>
                                <th  width="7%"><?php echo e($website_lang->where('lang_key','action')->first()->custom_lang); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $appointments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $appointment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e(++$index); ?></td>
                                <td><?php echo e($appointment->lawyer->name); ?></td>
                                <td><?php echo e(date('m-d-Y',strtotime($appointment->date))); ?></td>
                                <td><?php echo e($currency->currency_icon); ?><?php echo e($appointment->appointment_fee); ?></td>
                                <td><?php echo e(strtoupper($appointment->schedule->start_time).'-'.strtoupper($appointment->schedule->end_time)); ?></td>
                                <td>
                                    <?php if($appointment->payment_status==0): ?>
                                        <span class="badge badge-danger">Pending</span>
                                    <?php else: ?>
                                    <span class="badge badge-success">Success</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($appointment->already_treated==1): ?>
                                    <a href="<?php echo e(route('client.show-appointment',$appointment->id)); ?>" class="btn btn-success btn-sm"><i class="fas fa-eye"></i></a>
                                 <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </tbody>
                    </table>

                    <?php echo e($appointments->links()); ?>

                </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!--Dashboard End-->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.client.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/penastud/public_html/law/resources/views/client/profile/appointment.blade.php ENDPATH**/ ?>