
<?php $__env->startSection('title'); ?>
<title><?php echo e($website_lang->where('lang_key','meeting_history')->first()->custom_lang); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('client-content'); ?>


<!--Banner Start-->
<div class="banner-area flex" style="background-image:url(<?php echo e($banner->profile ? url($banner->profile) : ''); ?>);">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="banner-text">
                    <h1><?php echo e($website_lang->where('lang_key','meeting_history')->first()->custom_lang); ?></h1>
                    <ul>
                        <li><a href="<?php echo e(url('/')); ?>"><?php echo e($navigation->home); ?></a></li>
                        <li><span><?php echo e($website_lang->where('lang_key','meeting_history')->first()->custom_lang); ?></span></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
<!--Banner End-->

<!--Dashboard Start-->
<div class="dashboard-area pt_70 pb_70">
    <div class="container">
        <div class="row">
            <div class="col-lg-3">
                <?php echo $__env->make('client.profile.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-lg-9">
                <div class="detail-dashboard">
                    <h2 class="d-headline"><?php echo e($website_lang->where('lang_key','meeting_history')->first()->custom_lang); ?></h2>
                    <div class="table-responsive">
                        <table class="coustom-dashboard dashboard-table display" width="100%" cellspacing="0">
                            <thead>
                                <tr>
                                    <th ><?php echo e($website_lang->where('lang_key','serial')->first()->custom_lang); ?></th>
                                    <th ><?php echo e($website_lang->where('lang_key','lawyer')->first()->custom_lang); ?></th>
                                    <th ><?php echo e($website_lang->where('lang_key','time')->first()->custom_lang); ?></th>
                                    <th ><?php echo e($website_lang->where('lang_key','duration')->first()->custom_lang); ?></th>
                                    <th ><?php echo e($website_lang->where('lang_key','meeting_id')->first()->custom_lang); ?></th>
                                    <th ><?php echo e($website_lang->where('lang_key','join_link')->first()->custom_lang); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                    $i=0;
                                ?>
                                <?php $__currentLoopData = $histories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $meeting): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $now=date('Y-m-d h:i:A');
                                ?>

                                <?php if($now > date('Y-m-d h:i:A',strtotime($meeting->meeting_time))): ?>
                                <tr>
                                    <td><?php echo e(++$i); ?></td>
                                    <td><?php echo e($meeting->lawyer->name); ?></td>
                                    <td>
                                        <?php echo e(date('Y-m-d h:i:A',strtotime($meeting->meeting_time))); ?>

                                    </td>
                                    <td><?php echo e($meeting->duration); ?> <?php echo e($website_lang->where('lang_key','minute')->first()->custom_lang); ?></td>
                                    <td><?php echo e($meeting->meeting->meeting_id); ?></td>
                                    <td>
                                            <?php
                                                $time=date('Y-m-d h:i:A',strtotime($meeting->meeting_time));
                                                $hexacode=strtotime($meeting->meeting_time) + 60*$meeting->duration;
                                            ?>
                                            <?php if($now < date('Y-m-d h:i:A',$hexacode)): ?>
                                                <?php if(env('PROJECT_MODE')==0): ?>
                                                    <a id="zoom_demo_mode" href="javascript:;"  class="btn btn-success btn-sm"><i class="fas fa-video"></i></a>
                                                <?php else: ?>
                                                <a target="_blank" href="<?php echo e($meeting->meeting->join_url); ?>" class="btn btn-success btn-sm"><i class="fas fa-video"></i></a>
                                                <?php endif; ?>
                                            <?php else: ?>
                                            <a href="javascript:;"  class="btn btn-success btn-sm disabled"><i class="fas fa-video"></i></a>
                                            <?php endif; ?>


                                    </td>
                                </tr>
                                <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table>
                        <?php echo e($histories->links()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!--Dashboard End-->


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.client.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/penastud/public_html/law/resources/views/client/profile/meeting-history.blade.php ENDPATH**/ ?>