
<?php $__env->startSection('title'); ?>
<title><?php echo e($title_meta->lawyer_title); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta'); ?>
<meta name="description" content="<?php echo e($title_meta->lawyer_meta_description); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('client-content'); ?>

<!--Banner Start-->
<div class="banner-area flex" style="background-image:url(<?php echo e($banner->lawyer ? url($banner->lawyer) : ''); ?>);">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="banner-text">
                    <h1><?php echo e($navigation->lawyer); ?></h1>
                    <ul>
                        <li><a href="<?php echo e(url('/')); ?>"><?php echo e($navigation->home); ?></a></li>
                        <li><span><?php echo e($navigation->lawyer); ?></span></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
<!--Banner End-->


<div class="doctor-search">
    <div class="container">
        <div class="row">
            <div class="col-md-12">

                <div class="s-container">
                <form action="<?php echo e(url('search-lawyer')); ?>">

                    <div class="s-box">
                        <select name="location" class="form-control select2">
                            <option value=""><?php echo e($website_lang->where('lang_key','select_location')->first()->custom_lang); ?></option>
                            <?php $__currentLoopData = $locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $location): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option <?php echo e(@$location_id==$location->id?'selected':''); ?> value="<?php echo e($location->id); ?>"><?php echo e(ucwords($location->location)); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="s-box">
                        <select name="department" class="form-control select2">
                            <option value=""><?php echo e($website_lang->where('lang_key','select_department')->first()->custom_lang); ?></option>
                            <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option <?php echo e(@$department_id==$department->id?'selected':''); ?> value="<?php echo e($department->id); ?>"><?php echo e(ucwords($department->name)); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="s-box">
                        <select name="lawyer" class="form-control select2">
                            <option value=""><?php echo e($website_lang->where('lang_key','select_lawyer')->first()->custom_lang); ?></option>
                            <?php $__currentLoopData = $lawyersForSearch; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lawyer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option <?php echo e(@$lawyer_id==$lawyer->id?'selected':''); ?> value="<?php echo e($lawyer->id); ?>"><?php echo e($lawyer->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="s-button">
                        <button type="submit"><?php echo e($website_lang->where('lang_key','search')->first()->custom_lang); ?></button>
                    </div>
                </form>
                </div>

            </div>
        </div>
    </div>
</div>




<!--Service Start-->
<div class="team-page pt_40 pb_70">
    <div class="container">
        <div class="row">

            <?php if($lawyers->count()!=0): ?>
            <?php $__currentLoopData = $lawyers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lawyer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-lg-3 col-md-4 col-6 mt_30">
                <div class="team-item">
                    <div class="team-photo">
                        <img src="<?php echo e(url($lawyer->image)); ?>" alt="Team Photo">
                    </div>
                    <div class="team-text">
                        <a href="<?php echo e(url('lawyer-details/'.$lawyer->slug)); ?>"><?php echo e($lawyer->name); ?></a>
                        <p><?php echo e($lawyer->department->name); ?></p>
                        <p><span><i class="fas fa-graduation-cap"></i> <?php echo e($lawyer->designations); ?></span></p>
                        <p><span><b><i class="fas fa-street-view"></i> <?php echo e(ucfirst($lawyer->location->location)); ?></b></span></p>
                    </div>
                    <div class="team-social">
                        <ul>
                            <?php if($lawyer->facebook): ?>
                            <li><a href="<?php echo e($lawyer->facebook); ?>"><i class="fab fa-facebook-f"></i></a></li>
                            <?php endif; ?>
                            <?php if($lawyer->twitter): ?>
                            <li><a href="<?php echo e($lawyer->twitter); ?>"><i class="fab fa-twitter"></i></a></li>
                            <?php endif; ?>
                            <?php if($lawyer->linkedin): ?>
                            <li><a href="<?php echo e($lawyer->linkedin); ?>"><i class="fab fa-linkedin"></i></a></li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php else: ?>
            <h3 class="text-danger text-center"><?php echo e($website_lang->where('lang_key','lawyer_not_found')->first()->custom_lang); ?></h3>
            <?php endif; ?>


        </div>
        <?php echo e(@$lawyers->links('client.paginator')); ?>

    </div>
</div>
<!--Service End-->






<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.client.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/penastud/public_html/law/resources/views/client/lawyer/index.blade.php ENDPATH**/ ?>