
<?php $__env->startSection('title'); ?>
<title><?php echo e($website_lang->where('lang_key','order')->first()->custom_lang); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
 <!-- Appointment Details -->
 <h2><?php echo e($website_lang->where('lang_key','order_id')->first()->custom_lang); ?>: <b><?php echo e($order->order_id); ?></b> </h2>
 <div class="row">
    <div class="col-md-6">
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary"><?php echo e($website_lang->where('lang_key','client_info')->first()->custom_lang); ?></h6>
            </div>
            <div class="card-body">
                <table class="table table-bordered">
                    <tr>
                        <td><?php echo e($website_lang->where('lang_key','name')->first()->custom_lang); ?></td>
                        <td><?php echo e(ucwords($order->user->name)); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e($website_lang->where('lang_key','email')->first()->custom_lang); ?></td>
                        <td><?php echo e($order->user->email); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e($website_lang->where('lang_key','phone')->first()->custom_lang); ?></td>
                        <td><?php echo e($order->user->phone); ?></td>
                    </tr>

                    <tr>
                        <td><?php echo e($website_lang->where('lang_key','age')->first()->custom_lang); ?></td>
                        <td><?php echo e($order->user->age); ?></td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary"><?php echo e($website_lang->where('lang_key','billing_info')->first()->custom_lang); ?></h6>
            </div>
            <div class="card-body">
                <table class="table table-bordered">
                    <tbody>
                        <tr>
                            <td><?php echo e($website_lang->where('lang_key','appointment_fee')->first()->custom_lang); ?></td>
                            <td><?php echo e($currency->currency_icon); ?><?php echo e($order->total_payment); ?></td>
                        </tr>
                        <tr>
                            <td><?php echo e($website_lang->where('lang_key','payment_method')->first()->custom_lang); ?></td>
                            <td><?php echo e($order->payment_method); ?></td>
                        </tr>
                        <?php if($order->payment_transaction_id): ?>
                        <tr>
                            <td><?php echo e($website_lang->where('lang_key','tran_id')->first()->custom_lang); ?></td>
                            <td><?php echo e($order->payment_transaction_id); ?></td>
                        </tr>
                        <?php endif; ?>
                        <?php if($order->last4): ?>
                            <tr>
                                <td><?php echo e($website_lang->where('lang_key','stripe_last_digit')->first()->custom_lang); ?></td>
                                <td><?php echo e($order->last4); ?></td>
                            </tr>
                        <?php endif; ?>

                        <?php if($order->payment_description): ?>
                        <tr>
                            <td><?php echo e($website_lang->where('lang_key','description')->first()->custom_lang); ?></td>
                            <td><?php echo clean(nl2br(e($order->payment_description))); ?></td>
                        </tr>
                        <?php endif; ?>

                        <tr>
                            <td><?php echo e($website_lang->where('lang_key','payment_status')->first()->custom_lang); ?></td>
                            <td>
                                <?php if($order->payment_status==1): ?>
                                    <span class="badge badge-success"><?php echo e($website_lang->where('lang_key','success')->first()->custom_lang); ?></span>
                                <?php else: ?>
                                <span class="badge badge-danger"><?php echo e($website_lang->where('lang_key','pending')->first()->custom_lang); ?></span>
                                <?php endif; ?>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="col-md-12">
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary"><?php echo e($website_lang->where('lang_key','app_info')->first()->custom_lang); ?></h6>
            </div>
            <div class="card-body">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th><?php echo e($website_lang->where('lang_key','serial')->first()->custom_lang); ?></th>
                            <th><?php echo e($website_lang->where('lang_key','lawyer')->first()->custom_lang); ?></th>
                            <th><?php echo e($website_lang->where('lang_key','phone')->first()->custom_lang); ?></th>
                            <th><?php echo e($website_lang->where('lang_key','schedule')->first()->custom_lang); ?></th>
                            <th><?php echo e($website_lang->where('lang_key','date')->first()->custom_lang); ?></th>
                            <th><?php echo e($website_lang->where('lang_key','appointment_fee')->first()->custom_lang); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $order->appointments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e(++$index); ?></td>
                            <td><?php echo e($item->lawyer->name); ?></td>
                            <td><?php echo e($item->lawyer->phone); ?></td>
                            <td><?php echo e(strtoupper($item->schedule->start_time).'-'.strtoupper($item->schedule->end_time)); ?></td>
                            <td><?php echo e(date('m-d-Y',strtotime($item->date))); ?></td>
                            <td>
                                <?php echo e($currency->currency_icon); ?><?php echo e($item->appointment_fee); ?>

                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>


    <?php if($order->payment_status==0): ?>
        <a href="<?php echo e(route('admin.payment.accept',$order->id)); ?>" class="btn btn-success ml-3"><?php echo e($website_lang->where('lang_key','payment_accept')->first()->custom_lang); ?></a>
    <?php endif; ?>
    <a href="<?php echo e(route('admin.cancle.order',$order->id)); ?>" class="btn btn-danger ml-3"><?php echo e($website_lang->where('lang_key','delete_order')->first()->custom_lang); ?></a>

</div>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/penastud/public_html/law/resources/views/admin/order/show.blade.php ENDPATH**/ ?>