
<?php $__env->startSection('title'); ?>
<title><?php echo e($website_lang->where('lang_key','payment_account')->first()->custom_lang); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary"><?php echo e($website_lang->where('lang_key','payment_account')->first()->custom_lang); ?></h6>
                </div>
                <div class="card-body">
                    <nav>
                        <div class="nav nav-tabs" id="nav-tab" role="tablist">
                          <a class="nav-link active" id="paypal-tab" data-toggle="tab" href="#paypal-account" role="tab" aria-controls="paypal-account" aria-selected="true"><?php echo e($website_lang->where('lang_key','paypal')->first()->custom_lang); ?></a>

                          <a class="nav-link" id="stripe-tab" data-toggle="tab" href="#stripe-account" role="tab" aria-controls="nav-profile" aria-selected="false"><?php echo e($website_lang->where('lang_key','stripe')->first()->custom_lang); ?></a>

                          <a class="nav-link" id="razorpay-tab" data-toggle="tab" href="#razorpay-account" role="tab" aria-controls="razorpay-account" aria-selected="false"><?php echo e($website_lang->where('lang_key','razorpay')->first()->custom_lang); ?></a>

                          <a class="nav-link" id="flutterwave-tab" data-toggle="tab" href="#flutterwave-account" role="tab" aria-controls="flutterwave-account" aria-selected="false"><?php echo e($website_lang->where('lang_key','flutterwave')->first()->custom_lang); ?></a>

                          <a class="nav-link" id="bank-tab" data-toggle="tab" href="#bank-account" role="tab" aria-controls="razorpay-account" aria-selected="false"><?php echo e($website_lang->where('lang_key','bank')->first()->custom_lang); ?></a>

                        </div>
                      </nav>
                      <div class="tab-content" id="nav-tabContent">
                        <div class="tab-pane fade show active" id="paypal-account" role="tabpanel" aria-labelledby="paypal-tab">
                            <div class="mt-4">
                                <form action="<?php echo e(route('admin.payment-account.update',$paymentAccount->id)); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('patch'); ?>

                                    <div class="form-group">
                                        <label for=""><?php echo e($website_lang->where('lang_key','paypal_mode')->first()->custom_lang); ?></label>
                                        <select name="account_mode" id="" class="form-control">
                                            <option <?php echo e($paymentAccount->account_mode=='live' ? 'selected':''); ?> value="live"><?php echo e($website_lang->where('lang_key','live')->first()->custom_lang); ?></option>
                                            <option <?php echo e($paymentAccount->account_mode=='sandbox' ? 'selected':''); ?> value="sandbox"><?php echo e($website_lang->where('lang_key','sandbox')->first()->custom_lang); ?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="paypal_client_id"><?php echo e($website_lang->where('lang_key','paypal_client_id')->first()->custom_lang); ?></label>
                                        <textarea name="paypal_client_id" id="paypal_client_id" cols="30" rows="2" class="form-control"><?php echo e($paymentAccount->paypal_client_id); ?></textarea>

                                    </div>
                                    <div class="form-group">
                                        <label for="paypal_secret"><?php echo e($website_lang->where('lang_key','paypal_secret_key')->first()->custom_lang); ?></label>
                                        <textarea name="paypal_secret" id="paypal_secret" cols="30" rows="2" class="form-control" ><?php echo e($paymentAccount->paypal_secret); ?></textarea>

                                    </div>

                                    <div class="form-group">
                                        <label for=""><?php echo e($website_lang->where('lang_key','status')->first()->custom_lang); ?></label>
                                        <select name="paypal_status" id="" class="form-control">
                                            <option <?php echo e($paymentAccount->paypal_status==1 ? 'selected':''); ?> value="1"><?php echo e($website_lang->where('lang_key','active')->first()->custom_lang); ?></option>
                                            <option <?php echo e($paymentAccount->paypal_status==0 ? 'selected':''); ?> value="0"><?php echo e($website_lang->where('lang_key','inactive')->first()->custom_lang); ?></option>
                                        </select>
                                    </div>


                                    <button type="submit" class="btn btn-success"><?php echo e($website_lang->where('lang_key','update')->first()->custom_lang); ?></button>
                                </form>
                            </div>
                        </div>

                        <div class="tab-pane fade" id="stripe-account" role="tabpanel" aria-labelledby="stripe-tab">
                            <div class="mt-3">
                                <form action="<?php echo e(route('admin.stripe-update',$paymentAccount->id)); ?>" method="POST">
                                    <?php echo csrf_field(); ?>

                                    <div class="form-group">
                                        <label for="stripe_key"><?php echo e($website_lang->where('lang_key','stripe_key')->first()->custom_lang); ?></label>
                                        <textarea name="stripe_key" id="stripe_key" cols="30" rows="2" class="form-control"><?php echo e($paymentAccount->stripe_key); ?></textarea>

                                    </div>
                                    <div class="form-group">
                                        <label for="stripe_secret"><?php echo e($website_lang->where('lang_key','stripe_secret')->first()->custom_lang); ?></label>
                                        <textarea name="stripe_secret" id="stripe_secret" cols="30" rows="2" class="form-control"><?php echo e($paymentAccount->stripe_secret); ?></textarea>

                                    </div>

                                    <div class="form-group">
                                        <label for=""><?php echo e($website_lang->where('lang_key','status')->first()->custom_lang); ?></label>
                                        <select name="stripe_status" id="" class="form-control">
                                            <option <?php echo e($paymentAccount->stripe_status==1 ? 'selected':''); ?> value="1"><?php echo e($website_lang->where('lang_key','active')->first()->custom_lang); ?></option>
                                            <option <?php echo e($paymentAccount->stripe_status==0 ? 'selected':''); ?> value="0"><?php echo e($website_lang->where('lang_key','inactive')->first()->custom_lang); ?></option>
                                        </select>
                                    </div>

                                    <button type="submit" class="btn btn-success"><?php echo e($website_lang->where('lang_key','update')->first()->custom_lang); ?></button>
                                </form>
                            </div>
                        </div>

                        <div class="tab-pane fade" id="razorpay-account" role="tabpanel" aria-labelledby="razorpay-tab">
                            <div class="mt-3">
                                <form action="<?php echo e(route('admin.razorpay-update',$razorpay->id)); ?>" method="POST" enctype="multipart/form-data">
                                    <?php echo csrf_field(); ?>
                                    <div class="form-group">
                                        <label for=""><?php echo e($website_lang->where('lang_key','razorpay_key')->first()->custom_lang); ?></label>
                                        <input type="text" class="form-control" name="razorpay_key" value="<?php echo e($razorpay->razorpay_key); ?>">

                                    </div>
                                    <div class="form-group">
                                        <label for=""><?php echo e($website_lang->where('lang_key','razorpay_secret_key')->first()->custom_lang); ?></label>
                                        <input type="text" class="form-control" name="razorpay_secret" value="<?php echo e($razorpay->secret_key); ?>">
                                    </div>

                                    <div class="form-group">
                                        <label for=""><?php echo e($website_lang->where('lang_key','name')->first()->custom_lang); ?></label>
                                        <input type="text" class="form-control" name="name" value="<?php echo e($razorpay->name); ?>">
                                    </div>

                                    <div class="form-group">
                                        <label for=""><?php echo e($website_lang->where('lang_key','description')->first()->custom_lang); ?></label>
                                        <input type="text" class="form-control" name="description" value="<?php echo e($razorpay->description); ?>">
                                    </div>

                                    <div class="row">
                                        <div class="col-6">
                                            <div class="form-group">
                                                <label for=""><?php echo e($website_lang->where('lang_key','status')->first()->custom_lang); ?></label>
                                                <select name="razorpay_status" id="" class="form-control">
                                                    <option <?php echo e($razorpay->razorpay_status==1 ? 'selected':''); ?> value="1"><?php echo e($website_lang->where('lang_key','active')->first()->custom_lang); ?></option>
                                                    <option <?php echo e($razorpay->razorpay_status==0 ? 'selected':''); ?> value="0"><?php echo e($website_lang->where('lang_key','inactive')->first()->custom_lang); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <div class="form-group">
                                                <label for=""><?php echo e($website_lang->where('lang_key','active_currency')->first()->custom_lang); ?></label>
                                                <input type="text" value="<?php echo e($razorpay->currency_rate); ?>" class="form-control" name="currency_rate">
                                            </div>
                                        </div>
                                    </div>


                                    <div class="form-group">
                                        <label for=""><?php echo e($website_lang->where('lang_key','exist_image')->first()->custom_lang); ?></label>
                                        <div>
                                            <img width="200px" src="<?php echo e(asset($razorpay->image)); ?>" alt="">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for=""><?php echo e($website_lang->where('lang_key','image')->first()->custom_lang); ?></label>
                                        <input type="file" class="form-control-file" name="image">
                                    </div>

                                    <div class="form-group">
                                        <label for=""><?php echo e($website_lang->where('lang_key','theme_color')->first()->custom_lang); ?></label>
                                        <br>
                                        <input type="color" name="theme_color" value="<?php echo e($razorpay->theme_color); ?>">
                                    </div>

                                    <button type="submit" class="btn btn-success"><?php echo e($website_lang->where('lang_key','update')->first()->custom_lang); ?></button>
                                </form>
                            </div>
                        </div>

                        <div class="tab-pane fade" id="flutterwave-account" role="tabpanel" aria-labelledby="flutterwave-tab">
                            <div class="mt-3">
                                <form action="<?php echo e(route('admin.flutterwave-update',$flutterwave->id)); ?>" method="POST" enctype="multipart/form-data">
                                    <?php echo csrf_field(); ?>

                                    <div class="form-group">
                                        <label for=""><?php echo e($website_lang->where('lang_key','public_key')->first()->custom_lang); ?></label>
                                        <input type="text" class="form-control" name="public_key" value="<?php echo e($flutterwave->public_key); ?>">

                                    </div>
                                    <div class="form-group">
                                        <label for=""><?php echo e($website_lang->where('lang_key','secret_key')->first()->custom_lang); ?></label>
                                        <input type="text" class="form-control" name="secret_key" value="<?php echo e($flutterwave->secret_key); ?>">
                                    </div>

                                    <div class="form-group">
                                        <label for=""><?php echo e($website_lang->where('lang_key','title')->first()->custom_lang); ?></label>
                                        <input type="text" class="form-control" name="title" value="<?php echo e($flutterwave->title); ?>">
                                    </div>

                                    <div class="row">
                                        <div class="col-12">
                                            <div class="form-group">
                                                <label for=""><?php echo e($website_lang->where('lang_key','status')->first()->custom_lang); ?></label>
                                                <select name="status" id="" class="form-control">
                                                    <option <?php echo e($flutterwave->status==1 ? 'selected':''); ?> value="1"><?php echo e($website_lang->where('lang_key','active')->first()->custom_lang); ?></option>
                                                    <option <?php echo e($flutterwave->status==0 ? 'selected':''); ?> value="0"><?php echo e($website_lang->where('lang_key','inactive')->first()->custom_lang); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <label for=""><?php echo e($website_lang->where('lang_key','exist_image')->first()->custom_lang); ?></label>
                                        <div>
                                            <img width="200px" src="<?php echo e(asset($flutterwave->logo)); ?>" alt="">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for=""><?php echo e($website_lang->where('lang_key','new_image')->first()->custom_lang); ?></label>
                                        <input type="file" class="form-control-file" name="image">
                                    </div>


                                    <button type="submit" class="btn btn-success"><?php echo e($website_lang->where('lang_key','update')->first()->custom_lang); ?></button>
                                </form>
                            </div>
                        </div>

                        <div class="tab-pane fade" id="bank-account" role="tabpanel" aria-labelledby="bank-tab">
                            <div class="mt-3">
                                <form action="<?php echo e(route('admin.bank-update',$paymentAccount->id)); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <div class="form-group">
                                        <label for="bank_account"><?php echo e($website_lang->where('lang_key','bank_account')->first()->custom_lang); ?></label>
                                        <textarea name="bank_account" id="bank_account" cols="30" rows="5" class="form-control" ><?php echo e($paymentAccount->bank_account); ?></textarea>

                                    </div>

                                    <div class="form-group">
                                        <label for=""><?php echo e($website_lang->where('lang_key','status')->first()->custom_lang); ?></label>
                                        <select name="bank_status" id="" class="form-control">
                                            <option <?php echo e($paymentAccount->bank_status==1 ? 'selected':''); ?> value="1"><?php echo e($website_lang->where('lang_key','active')->first()->custom_lang); ?></option>
                                            <option <?php echo e($paymentAccount->bank_status==0 ? 'selected':''); ?> value="0"><?php echo e($website_lang->where('lang_key','inactive')->first()->custom_lang); ?></option>
                                        </select>
                                    </div>

                                    <button type="submit" class="btn btn-success"><?php echo e($website_lang->where('lang_key','update')->first()->custom_lang); ?></button>
                                </form>
                            </div>
                        </div>

                      </div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/penastud/public_html/law/resources/views/admin/payment-account/edit.blade.php ENDPATH**/ ?>