
<?php $__env->startSection('title'); ?>
<title><?php echo e($website_lang->where('lang_key','message')->first()->custom_lang); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('client-content'); ?>

<style>
    /* width */
    ::-webkit-scrollbar {
        width: 7px;
    }

    /* Track */
    ::-webkit-scrollbar-track {
        background: #f1f1f1;
    }

    /* Handle */
    ::-webkit-scrollbar-thumb {
        background: #a7a7a7;
    }

    /* Handle on hover */
    ::-webkit-scrollbar-thumb:hover {
        background: #929292;
    }

    ul {
        margin: 0;
        padding: 0;
    }

    li {
        list-style: none;
    }

    .user-wrapper, .message-wrapper {
        border: 1px solid #dddddd;
        overflow-y: auto;
    }

    .user-wrapper {
        height: 600px;
    }

    .user {
        cursor: pointer;
        padding: 5px 0;
        position: relative;
    }

    .user:hover {
        background: #eeeeee;
    }

    .user:last-child {
        margin-bottom: 0;
    }

    .pending {
        position: absolute;
        left: 13px;
        top: 9px;
        background: #b600ff;
        margin: 0;
        border-radius: 50%;
        width: 18px;
        height: 18px;
        line-height: 18px;
        padding-left: 5px;
        color: #ffffff !important;
        font-size: 12px;
    }

    .media-left {
        margin: 0 10px;
    }

    .media-left img {
        width: 64px;
        border-radius: 64px;
        height: 64px;
        object-fit: cover !important;
    }

    .media-body p {
        margin: 6px 0;
    }

    .message-wrapper {
        padding: 10px;
        height: 536px;
        background: #eeeeee;
    }

    .messages .message {
        margin-bottom: 15px;
    }

    .messages .message:last-child {
        margin-bottom: 0;
    }

    .received, .sent {
        max-width: 100%;
        padding: 3px 10px;
        border-radius: 10px;
    }

    .received {
        background: #ffffff;
    }

    .sent {
        background: #3bebff;
        float: right;
        text-align: right;
    }

    .message p {
        margin: 5px 0;
    }

    .date {
        color: #777777;
        font-size: 12px;
    }

    .active {
        background: #eeeeee;
    }

    input[type=text] {
        width: 100%;
        padding: 12px 20px;
        margin: 15px 0 0 0;
        display: inline-block;
        border-radius: 4px;
        box-sizing: border-box;
        outline: none;
        border: 1px solid #cccccc;
    }

    input[type=text]:focus {
        border: 1px solid #aaaaaa;
    }
    #sentMessageBtn{
        margin-top: 15px;
        padding: 10px;
    }
</style>

<!--Banner Start-->
<div class="banner-area flex" style="background-image:url(<?php echo e($banner->profile ? url($banner->profile) : ''); ?>);">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="banner-text">
                    <h1><?php echo e($website_lang->where('lang_key','message')->first()->custom_lang); ?></h1>
                    <ul>
                        <li><a href="<?php echo e(url('/')); ?>"><?php echo e($navigation->home); ?></a></li>
                        <li><span><?php echo e($website_lang->where('lang_key','message')->first()->custom_lang); ?></span></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
<!--Banner End-->

<!--Dashboard Start-->
<div class="dashboard-area pt_70 pb_70">
    <div class="container">
        <div class="row">
            <div class="col-lg-3">
                <?php echo $__env->make('client.profile.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-lg-9">
                <div class="detail-dashboard add-form">
                    <div class="row">
                        <div class="col-md-5">
                            <div class="user-wrapper">
                                <ul class="users">
                                    <?php $__currentLoopData = $lawyers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lawyer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="user" id="<?php echo e($lawyer->lawyer->id); ?>">
                                        <?php
                                            $cleint=Auth::guard('web')->user();
                                            $count=App\Message::where(['user_id'=>$cleint->id,'lawyer_id'=>$lawyer->lawyer->id,'user_view'=>0])->count();
                                        ?>
                                        <?php if($count>0): ?>
                                        <span class="pending"><?php echo e($count); ?></span>
                                        <?php endif; ?>

                                        <div class="media">
                                            <div class="media-left">
                                                <img src="<?php echo e(url($lawyer->lawyer->image)); ?>" alt="doctor image" class="media-object">
                                            </div>

                                            <div class="media-body">
                                                <p class="name"><?php echo e($lawyer->lawyer->name); ?></p>
                                                <p class="email"><?php echo e($lawyer->lawyer->email); ?></p>
                                            </div>
                                        </div>
                                    </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        </div>
                        <div class="col-md-7" id="messages">

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!--Dashboard End-->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.client.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/penastud/public_html/law/resources/views/client/profile/message/index.blade.php ENDPATH**/ ?>