
<?php $__env->startSection('title'); ?>
<title><?php echo e($department->seo_title); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta'); ?>
<meta name="description" content="<?php echo e($department->seo_description); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('client-content'); ?>

<!--Banner Start-->
<div class="banner-area flex" style="background-image:url(<?php echo e($banner->department ? url($banner->department) : ''); ?>);">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="banner-text">
                    <h1><?php echo e($department->name); ?></h1>
                    <ul>
                        <li><a href="<?php echo e(url('/')); ?>"><?php echo e($navigation->home); ?></a></li>
                        <li><span><?php echo e($department->name); ?></span></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
<!--Banner End-->



<div class="service-detail-area pt_40">
    <div class="container">
        <div class="row">
            <div class="col-md-8">
                <div class="service-detail-text pt_30">

                    <div class="row mb_30">
                        <div class="col-md-12">
                            <!-- Swiper -->
                            <div class="swiper-container pro-detail-top">
                                <div class="swiper-wrapper">
                                    <?php $__currentLoopData = $department->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="swiper-slide">
                                        <div class="catagory-item">
                                            <div class="catagory-img-holder">
                                                <img src="<?php echo e(url($item->image)); ?>" alt="">
                                                <div class="catagory-text">
                                                    <div class="catagory-text-table">
                                                        <div class="catagory-text-cell">
                                                            <ul class="catagory-hover">
                                                                <li><a href="<?php echo e(url($item->image)); ?>" class="magnific"><i class="fas fa-search"></i></a></li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                </div>
                                <!-- Add Arrows -->
                                <div class="swiper-button-next swiper-button-white"></div>
                                <div class="swiper-button-prev swiper-button-white"></div>
                            </div>
                            <div class="swiper-container pro-detail-thumbs">
                                <div class="swiper-wrapper">
                                    <?php $__currentLoopData = $department->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="swiper-slide"><img src="<?php echo e(url($item->image)); ?>" alt=""></div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                    <?php echo clean($department->description); ?>

                </div>
                <?php if($department->faqs->count()!=0): ?>
                <div class="row">
                    <div class="col-md-12">
                        <div class="faq-service feature-section-text mt_50">
                            <h2><?php echo e($website_lang->where('lang_key','faq')->first()->custom_lang); ?></h2>
                            <div class="feature-accordion" id="accordion">
                                <?php $__currentLoopData = $department->faqs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $faq): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="faq-item card">
                                    <div class="faq-header" id="heading-<?php echo e($faq->id); ?>">
                                        <button class="faq-button collapsed" data-toggle="collapse" data-target="#collapse-<?php echo e($faq->id); ?>" aria-expanded="true" aria-controls="collapse-<?php echo e($faq->id); ?>"><?php echo e($faq->question); ?></button>
                                    </div>

                                    <div id="collapse-<?php echo e($faq->id); ?>" class="collapse" aria-labelledby="heading-<?php echo e($faq->id); ?>" data-parent="#accordion">
                                        <div class="faq-body">
                                            <?php echo clean($faq->answer); ?>

                                        </div>
                                    </div>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                            </div>
                        </div>

                    </div>
                </div>
                <?php endif; ?>

                <?php if($department->videos->count()!=0): ?>
                <div class="row mt_50">
                    <div class="col-12">
                        <div class="video-headline">
                            <h3><?php echo e($website_lang->where('lang_key','related_video')->first()->custom_lang); ?></h3>
                        </div>
                    </div>

                    <?php $__currentLoopData = $department->videos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $video): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>


                        <div class="col-md-6">
                            <div class="video-item mt_30">
                                <div class="video-img">
                                    <?php
                                        $video_id=explode("=",$video->link);

                                    ?>
                                    <img src="https://img.youtube.com/vi/<?php echo e($video_id[1]); ?>/0.jpg">
                                    <div class="video-section">
                                        <a class="video-button mgVideo" href="<?php echo e($video->link); ?>"><span></span></a>

                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <?php endif; ?>
            </div>
            <div class="col-md-4">
                <div class="service-sidebar pt_30">
                    <div class="service-widget">
                        <ul>
                            <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="<?php echo e($item->id==$department->id ? 'active':''); ?>"><a href="<?php echo e(url('department-details/'.$item->slug)); ?>"><i class="fas fa-chevron-right"></i> <?php echo e($item->name); ?></a></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                    <div class="service-widget-contact mt_45">
                        <h2><?php echo e($contactInfo->header); ?></h2>
                        <p><?php echo e($contactInfo->description); ?></p>
                        <ul>
                            <li><i class="fas fa-phone"></i> <?php echo nl2br(e($contactInfo->phones)); ?></li>
                            <li><i class="far fa-envelope"></i> <?php echo nl2br(e($contactInfo->emails)); ?></li>
                            <li><i class="fas fa-map-marker-alt"></i><?php echo nl2br(e($contactInfo->address)); ?></li>
                        </ul>
                    </div>
                    <div class="service-qucikcontact event-form mt_30">
                        <h3><?php echo e($website_lang->where('lang_key','quick_contact')->first()->custom_lang); ?></h3>
                        <form action="<?php echo e(url('contact-message')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="form-row row">
                                <div class="form-group col-md-12">
                                    <input type="text" class="form-control" id="name" placeholder="<?php echo e($website_lang->where('lang_key','name')->first()->custom_lang); ?>" name="name">
                                </div>
                                <div class="form-group col-md-12">
                                    <input type="text" class="form-control" placeholder="<?php echo e($website_lang->where('lang_key','phone')->first()->custom_lang); ?>" name="phone">
                                </div>
                                <div class="form-group col-md-12">
                                    <input type="email" class="form-control" placeholder="<?php echo e($website_lang->where('lang_key','email')->first()->custom_lang); ?>" name="email">
                                </div>
                                <div class="form-group col-md-12">
                                    <input type="text" class="form-control" placeholder="<?php echo e($website_lang->where('lang_key','subject')->first()->custom_lang); ?>" name="subject">
                                </div>

                                <div class="form-group col-md-12">
                                    <textarea name="message" class="form-control" placeholder="<?php echo e($website_lang->where('lang_key','message')->first()->custom_lang); ?>"></textarea>
                                </div>
                                <?php if($setting->allow_captcha==1): ?>
                                <div class="form-group col-12">
                                    <div class="g-recaptcha" data-sitekey="<?php echo e($setting->captcha_key); ?>"></div>
                                </div>
                                <?php endif; ?>

                                <div class="form-group col-md-12">
                                    <button type="submit" class="btn"><?php echo e($website_lang->where('lang_key','send_message')->first()->custom_lang); ?></button>
                                </div>

                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>


    </div>
</div>


<?php if($lawyers->count()!=0): ?>
<div class="team-page pt_40 pb_70 bg_f2f2f2">
    <div class="container">
        <div class="row">
            <div class="col-md-12 wow fadeInDown" data-wow-delay="0.1s">
                <div class="main-headline">
                    <h1><?php echo e($website_lang->where('lang_key','department_lawyers')->first()->custom_lang); ?></h1>
                    <p><?php echo e($description); ?></p>
                </div>
            </div>
        </div>


        <div class="row">

            <?php if($lawyers->count()!=0): ?>
            <?php $__currentLoopData = $lawyers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lawyer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-lg-3 col-md-4 col-6 mt_30">
                <div class="team-item">
                    <div class="team-photo">
                        <img src="<?php echo e(url($lawyer->image)); ?>" alt="Team Photo">
                    </div>
                    <div class="team-text">
                        <a href="<?php echo e(url('lawyer-details/'.$lawyer->slug)); ?>"><?php echo e(ucfirst($lawyer->name)); ?></a>
                        <p><?php echo e(ucfirst($lawyer->department->name)); ?></p>
                        <p><span><i class="fas fa-graduation-cap"></i> <?php echo e($lawyer->designations); ?></span></p>
                        <p><span><b><i class="fas fa-street-view"></i> <?php echo e(ucfirst($lawyer->location->location)); ?></b></span></p>
                    </div>
                    <div class="team-social">
                        <ul>
                            <?php if($lawyer->facebook): ?>
                            <li><a href="<?php echo e($lawyer->facebook); ?>"><i class="fab fa-facebook-f"></i></a></li>
                            <?php endif; ?>
                            <?php if($lawyer->twitter): ?>
                            <li><a href="<?php echo e($lawyer->twitter); ?>"><i class="fab fa-twitter"></i></a></li>
                            <?php endif; ?>
                            <?php if($lawyer->linkedin): ?>
                            <li><a href="<?php echo e($lawyer->linkedin); ?>"><i class="fab fa-linkedin"></i></a></li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php else: ?>
            <h3 class="text-danger text-center"><?php echo e($website_lang->where('lang_key','lawyer_not_found')->first()->custom_lang); ?></h3>
            <?php endif; ?>


        </div>
    </div>
</div>
<?php endif; ?>





<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.client.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/penastud/public_html/law/resources/views/client/department/show.blade.php ENDPATH**/ ?>