
<?php $__env->startSection('title'); ?>
<title><?php echo e($website_lang->where('lang_key','faq_category')->first()->custom_lang); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
    <!-- Page Heading -->
    <h1 class="h3 mb-2 text-gray-800"><a href="javascript:;" data-toggle="modal" data-target="#newCategory" class="btn btn-primary"><i class="fas fa-plus" aria-hidden="true"></i> <?php echo e($website_lang->where('lang_key','create')->first()->custom_lang); ?> </a></h1>
    <!-- DataTales Example -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary"><?php echo e($website_lang->where('lang_key','faq_cat_table')->first()->custom_lang); ?></h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th width="5%"><?php echo e($website_lang->where('lang_key','serial')->first()->custom_lang); ?></th>
                            <th width="30%"><?php echo e($website_lang->where('lang_key','name')->first()->custom_lang); ?></th>
                            <th width="10%"><?php echo e($website_lang->where('lang_key','status')->first()->custom_lang); ?></th>
                            <th width="15%"><?php echo e($website_lang->where('lang_key','action')->first()->custom_lang); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e(++$index); ?></td>
                            <td><?php echo e($item->name); ?></td>
                            <td>
                                <?php if($item->status==1): ?>
                                <a href="" onclick="faqCategoryStatus(<?php echo e($item->id); ?>)"><input type="checkbox" checked data-toggle="toggle" data-on="<?php echo e($website_lang->where('lang_key','active')->first()->custom_lang); ?>" data-off="<?php echo e($website_lang->where('lang_key','inactive')->first()->custom_lang); ?>" data-onstyle="success" data-offstyle="danger"></a>
                                <?php else: ?>
                                    <a href="" onclick="faqCategoryStatus(<?php echo e($item->id); ?>)"><input type="checkbox" data-toggle="toggle" data-on="<?php echo e($website_lang->where('lang_key','active')->first()->custom_lang); ?>" data-off="<?php echo e($website_lang->where('lang_key','inactive')->first()->custom_lang); ?>" data-onstyle="success" data-offstyle="danger"></a>

                                <?php endif; ?>
                            </td>
                            <td>
                                <a href="javascript:;" data-toggle="modal" data-target="#updateCategory-<?php echo e($item->id); ?>" class="btn btn-primary btn-sm"><i class="fas fa-edit    "></i></a>
                                <a data-toggle="modal" data-target="#deleteModal" href="javascript:;" onclick="deleteData(<?php echo e($item->id); ?>)" class="btn btn-danger btn-sm"><i class="fas fa-trash    "></i></a>
                                <a href="<?php echo e(route('admin.faq.category',$item->slug)); ?>" class="btn btn-success btn-sm"><i class="fas fa-plus" aria-hidden="true"></i><?php echo e($website_lang->where('lang_key','create_faq')->first()->custom_lang); ?></a>

                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Create Blog Category Modal -->
    <div class="modal fade" id="newCategory" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                    <div class="modal-header">
                            <h5 class="modal-title"><?php echo e($website_lang->where('lang_key','faq_category')->first()->custom_lang); ?></h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                        </div>
                <div class="modal-body">
                    <div class="container-fluid">

                        <form action="<?php echo e(route('admin.faq-category.store')); ?>" method="post">
                            <?php echo csrf_field(); ?>
                            <div class="form-group">
                                <label for="name"><?php echo e($website_lang->where('lang_key','name')->first()->custom_lang); ?></label>
                                <input type="text" class="form-control" name="name" id="name">
                            </div>
                            <div class="form-group">
                                <label for="status"><?php echo e($website_lang->where('lang_key','status')->first()->custom_lang); ?></label>
                                <select name="status" id="status" class="form-control">
                                    <option value="1"><?php echo e($website_lang->where('lang_key','active')->first()->custom_lang); ?></option>
                                    <option value="0"><?php echo e($website_lang->where('lang_key','inactive')->first()->custom_lang); ?></option>
                                </select>
                            </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" data-dismiss="modal"><?php echo e($website_lang->where('lang_key','close')->first()->custom_lang); ?></button>
                    <button type="submit" class="btn btn-primary"><?php echo e($website_lang->where('lang_key','save')->first()->custom_lang); ?></button>
                </div>
            </form>
            </div>
        </div>
    </div>

    <!-- update Blog Category Modal -->
    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="modal fade" id="updateCategory-<?php echo e($item->id); ?>" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                        <div class="modal-header">
                                <h5 class="modal-title"><?php echo e($website_lang->where('lang_key','faq_category')->first()->custom_lang); ?></h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                            </div>
                    <div class="modal-body">
                        <div class="container-fluid">

                            <form action="<?php echo e(route('admin.faq-category.update',$item->id)); ?>" method="post">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('patch'); ?>
                                <div class="form-group">
                                    <label for="name"><?php echo e($website_lang->where('lang_key','name')->first()->custom_lang); ?></label>
                                    <input type="text" class="form-control" name="name" id="name" value="<?php echo e($item->name); ?>">
                                </div>
                                <div class="form-group">
                                    <label for="status"><?php echo e($website_lang->where('lang_key','status')->first()->custom_lang); ?></label>
                                    <select name="status" id="status" class="form-control">
                                        <option <?php echo e($item->status==1 ? 'selected' :''); ?> value="1"><?php echo e($website_lang->where('lang_key','active')->first()->custom_lang); ?></option>
                                        <option <?php echo e($item->status==0 ? 'selected' :''); ?> value="0"><?php echo e($website_lang->where('lang_key','inactive')->first()->custom_lang); ?></option>
                                    </select>
                                </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger" data-dismiss="modal"><?php echo e($website_lang->where('lang_key','close')->first()->custom_lang); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo e($website_lang->where('lang_key','update')->first()->custom_lang); ?></button>
                    </div>
                </form>
                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



    <script>
        function deleteData(id){
            $("#deleteForm").attr("action",'<?php echo e(url("admin/faq-category/")); ?>'+"/"+id)
        }

        function faqCategoryStatus(id){

// project demo mode check
         var isDemo="<?php echo e(env('PROJECT_MODE')); ?>"
         var demoNotify="<?php echo e(env('NOTIFY_TEXT')); ?>"
         if(isDemo==0){
             toastr.error(demoNotify);
             return;
         }
         // end
            $.ajax({
                type:"get",
                url:"<?php echo e(url('/admin/faq-category-status/')); ?>"+"/"+id,
                success:function(response){
                   toastr.success(response)
                },
                error:function(err){
                    console.log(err);

                }
            })
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/penastud/public_html/law/resources/views/admin/faq/category/index.blade.php ENDPATH**/ ?>