
<?php $__env->startSection('title'); ?>
<title><?php echo e($navigation->payment); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('client-content'); ?>


<!--Banner Start-->
<div class="banner-area flex" style="background-image:url(<?php echo e($banner->payment ?  url($banner->payment) : ''); ?>);">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="banner-text">
                    <h1><?php echo e($navigation->payment); ?></h1>
                    <ul>
                        <li><a href="<?php echo e(url('/')); ?>"><?php echo e($navigation->home); ?></a></li>
                        <li><span><?php echo e($navigation->payment); ?></span></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
<!--Banner End-->

<!--Check Out Start-->
<div class="check-out pt_40 pb_70">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="checkout-table table-responsive">

                    <h4><?php echo e($website_lang->where('lang_key','appointment_list')->first()->custom_lang); ?></h4>

                    <table class="table">
                        <thead>
                            <tr>
                                <th><b><?php echo e($website_lang->where('lang_key','lawyer')->first()->custom_lang); ?></b></th>
                                <th><b><?php echo e($website_lang->where('lang_key','department')->first()->custom_lang); ?></b></th>
                                <th><b><?php echo e($website_lang->where('lang_key','location')->first()->custom_lang); ?></b></th>
                                <th><b><?php echo e($website_lang->where('lang_key','date')->first()->custom_lang); ?></b></th>
                                <th><b><?php echo e($website_lang->where('lang_key','time')->first()->custom_lang); ?></b></th>
                                <th><b><?php echo e($website_lang->where('lang_key','appointment_fee')->first()->custom_lang); ?> (<?php echo e($currency->currency_name); ?>)</b></th>
                                <th><b><?php echo e($website_lang->where('lang_key','action')->first()->custom_lang); ?></b></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $appointments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e(ucfirst($item->name)); ?></td>
                                <td><?php echo e($item->options->department); ?></td>
                                <td><?php echo e($item->options->location); ?></td>
                                <td><?php echo e($item->options->date); ?></td>
                                <td><?php echo e(strtoupper($item->options->time)); ?></td>
                                <td><?php echo e($currency->currency_icon); ?><?php echo e($item->price); ?></td>
                                <td><a href="<?php echo e(url('remove-appointment/'.$item->rowId)); ?>" class="btn btn-danger btn-sm"><i class="fas fa-times"></i></a></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                            <tr>
                                <td class="text-right" colspan="5"><b>Total</b></td>
                                <td class="" colspan="2"><b><?php echo e($currency->currency_icon); ?><?php echo e(Cart::pricetotal()); ?></b></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <?php if($appointments->count() !=0): ?>
        <div class="row">
            <div class="col-12">
                <div class="payment-select">
                    <h4><?php echo e($website_lang->where('lang_key','pay_now')->first()->custom_lang); ?></h4>
                    <ul class="nav nav-tabs" id="myTab" role="tablist">

                        <?php if($paymentSetting->stripe_status==1): ?>
                            <li class="nav-item" role="presentation">
                            <a class="nav-link active" id="stripe-tab" data-toggle="tab" href="#stripe" role="tab" aria-controls="stripe" aria-selected="true"><?php echo e($website_lang->where('lang_key','stripe')->first()->custom_lang); ?></a>
                            </li>
                        <?php endif; ?>

                        <?php if($paymentSetting->paypal_status==1): ?>
                            <li class="nav-item" role="presentation">
                            <a class="nav-link" id="paypal-tab" data-toggle="tab" href="#paypal" role="tab" aria-controls="paypal" aria-selected="false"><?php echo e($website_lang->where('lang_key','paypal')->first()->custom_lang); ?></a>
                            </li>
                        <?php endif; ?>

                        <?php if($razorpay->razorpay_status==1): ?>
                            <li class="nav-item" role="presentation">
                            <a class="nav-link" id="razorpay-tab" data-toggle="tab" href="#razorpay" role="tab" aria-controls="paypal" aria-selected="false"><?php echo e($website_lang->where('lang_key','razorpay')->first()->custom_lang); ?></a>
                            </li>
                        <?php endif; ?>

                        <?php if($flutterwave->status): ?>
                            <li class="nav-item" role="presentation">
                            <a class="nav-link" id="flutterwave-tab" data-toggle="tab" href="#flutterwave" role="tab" aria-controls="paypal" aria-selected="false"><?php echo e($website_lang->where('lang_key','flutterwave')->first()->custom_lang); ?></a>
                            </li>
                        <?php endif; ?>


                        <?php if($paymentSetting->bank_status==1): ?>
                            <li class="nav-item" role="presentation">
                            <a class="nav-link" id="bank-tab" data-toggle="tab" href="#bank" role="tab" aria-controls="bank" aria-selected="false"><?php echo e($website_lang->where('lang_key','bank_transfer')->first()->custom_lang); ?></a>
                            </li>
                        <?php endif; ?>

                      </ul>
                      <div class="tab-content" id="myTabContent">
                        <?php if($paymentSetting->stripe_status==1): ?>
                            <div class="tab-pane fade show active mt-5" id="stripe" role="tabpanel" aria-labelledby="stripe-tab">
                                <div class="payment-select-group">
                                    <?php if(Session::has('success')): ?>
                                        <div class="alert alert-success text-center">
                                            <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
                                            <p><?php echo e(Session::get('success')); ?></p>
                                        </div>
                                    <?php endif; ?>
                                    <form role="form" action="<?php echo e(route('client.stripe.payment')); ?>" method="post" class="require-validation"
                                    data-cc-on-file="false"
                                    data-stripe-publishable-key="<?php echo e($stripe->stripe_key); ?>"
                                    id="payment-form">
                                    <?php echo csrf_field(); ?>

                                    <div class='form-row row mt_30'>
                                        <div class='col-sm-6 col-12 form-group required'>
                                            <label class='control-label'><?php echo e($website_lang->where('lang_key','card_number')->first()->custom_lang); ?></label> <input
                                                autocomplete='off' class='form-control card-number' size='20'
                                                type='text' name="card_digit">
                                        </div>


                                        <div class='col-sm-6 col-12 form-group cvc required'>
                                            <label class='control-label'><?php echo e($website_lang->where('lang_key','cvc')->first()->custom_lang); ?></label> <input autocomplete='off'
                                                class='form-control card-cvc' size='4'
                                                type='text'>
                                        </div>

                                        <div class='col-sm-6 col-12 form-group expiration required'>
                                            <label class='control-label'><?php echo e($website_lang->where('lang_key','exp_month')->first()->custom_lang); ?></label> <input
                                                class='form-control card-expiry-month' size='2'
                                                type='text'>
                                        </div>

                                        <div class='col-sm-6 col-12 form-group expiration required'>
                                            <label class='control-label'><?php echo e($website_lang->where('lang_key','exp_year')->first()->custom_lang); ?></label> <input
                                                class='form-control card-expiry-year'  size='4'
                                                type='text'>
                                        </div>
                                    </div>
                                    <div class='form-row row'>
                                        <div class='col-md-12 error form-group hide d-none'>
                                            <div class='alert-danger alert'><?php echo e($website_lang->where('lang_key','card_error')->first()->custom_lang); ?></div>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="payment-order-button col-3">
                                        <button type="submit"><?php echo e($website_lang->where('lang_key','pay_with_stripe')->first()->custom_lang); ?></button>
                                    </div>
                                </div>
                            </form>
                            </div>
                        <?php endif; ?>

                        <?php if($paymentSetting->paypal_status==1): ?>
                        <div class="tab-pane fade mt-5" id="paypal" role="tabpanel" aria-labelledby="paypal-tab">
                            <form action="<?php echo e(url('client/store-paypal')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="payment-order-button col-3">
                                    <button type="submit"><?php echo e($website_lang->where('lang_key','pay_with_paypal')->first()->custom_lang); ?></button>
                                </div>
                            </div>
                        </form>
                        </div>
                        <?php endif; ?>

                        <?php if($razorpay->razorpay_status==1): ?>
                        <div class="tab-pane fade mt-5" id="razorpay" role="tabpanel" aria-labelledby="razorpay-tab">
                            <form action="<?php echo e(route('client.razorpay-payment')); ?>" method="POST" >
                                <?php echo csrf_field(); ?>

                                <?php
                                    $inr_amount = round(Cart::pricetotal() / $razorpay->currency_rate,2);
                                ?>

                                <script src="https://checkout.razorpay.com/v1/checkout.js"
                                        data-key="<?php echo e($razorpay->razorpay_key); ?>"
                                        data-amount= "<?php echo e($inr_amount * 100); ?>"
                                        data-buttontext="<?php echo e($website_lang->where('lang_key','pay')->first()->custom_lang); ?> <?php echo e($inr_amount); ?> <?php echo e($website_lang->where('lang_key','inr')->first()->custom_lang); ?>"
                                        data-name="<?php echo e($razorpay->name); ?>"
                                        data-description="<?php echo e($razorpay->description); ?>"
                                        data-image="<?php echo e(asset($razorpay->image)); ?>"
                                        data-prefill.name=""
                                        data-prefill.email=""
                                        data-theme.color="<?php echo e($razorpay->theme_color); ?>">
                                </script>
                            </form>
                        </div>
                        <?php endif; ?>

                        <?php
                            $usd_amount= round(Cart::pricetotal() / $setting->currency_rate,2);
                            $tnx_ref = substr(rand(0,time()),0,7);
                        ?>

                        <?php if($flutterwave->status): ?>
                            <div class="tab-pane fade mt-5" id="flutterwave" role="tabpanel" aria-labelledby="flutterwave-tab">
                                <div class="row">
                                    <div class="payment-order-button col-6">
                                        <button type="button" onclick="makePayment()"><?php echo e($website_lang->where('lang_key','pay_with_flutterwave')->first()->custom_lang); ?></button>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>


                        <?php if($paymentSetting->bank_status==1): ?>
                        <div class="tab-pane fade mt-5" id="bank" role="tabpanel" aria-labelledby="bank-tab">
                            <div class="row">
                                <div class="col-md-6">
                                    <form action="<?php echo e(route('client.bank.payment')); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <div class="form-group">
                                            <label for="description"><?php echo e($website_lang->where('lang_key','tran_info')->first()->custom_lang); ?></label>
                                            <textarea name="description" id="description" cols="30" rows="10" class="form-control" required></textarea>
                                        </div>

                                        <div class="payment-order-button">
                                            <button type="submit"><?php echo e($website_lang->where('lang_key','payment')->first()->custom_lang); ?></button>
                                        </div>

                                    </form>
                                </div>
                                <div class="col-md-6">
                                    <div class="bank contact-info-item bg2 mb_30 mt_30">
                                        <div class="contact-info">
                                            <span>
                                                <?php echo e($website_lang->where('lang_key','bank_acc_info')->first()->custom_lang); ?>:
                                            </span>
                                            <div class="contact-text">
                                                <p class="card-text">
                                                    <?php echo clean(nl2br(e($stripe->bank_account))); ?></p>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>

                        </div>
                        <?php endif; ?>

                      </div>

                </div>

            </div>
        </div>
        <?php endif; ?>
    </div>
</div>
<!--Check Out End-->


<?php if($appointments->count() !=0): ?>
<script src="https://checkout.flutterwave.com/v3.js"></script>
<script>
    function makePayment() {
      FlutterwaveCheckout({
        public_key: "<?php echo e($flutterwave->public_key); ?>",
        tx_ref: "RX1_<?php echo e($tnx_ref); ?>",
        amount: <?php echo e($usd_amount); ?>,
        currency: "USD",
        country: "US",
        payment_options: " ",
        customer: {
          email: "<?php echo e($user->email); ?>",
          phone_number: "<?php echo e($user->phone); ?>",
          name: "<?php echo e($user->name); ?>",
        },
        callback: function (data) {
            var tnx_id = data.transaction_id;
            var _token = "<?php echo e(csrf_token()); ?>";
            $.ajax({
                type: 'post',
                data : {tnx_id,_token},
                url: "<?php echo e(url('client/flutterwave-payment/')); ?>",
                success: function (response) {
                    if(response.status == 'success'){
                        toastr.success(response.message);
                        window.location.href = "<?php echo e(route('client.order')); ?>";
                    }else{
                        toastr.error(response.message);
                        window.location.reload();

                    }
                },
                error: function(err) {}
            });

        },
        customizations: {
          title: "<?php echo e($flutterwave->title); ?>",
          logo: "<?php echo e(asset($flutterwave->logo)); ?>",
        },
      });
    }
  </script>
<?php endif; ?>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.client.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/penastud/public_html/law/resources/views/client/profile/payment.blade.php ENDPATH**/ ?>