
<?php $__env->startSection('title'); ?>
<title><?php echo e($website_lang->where('lang_key','schedule')->first()->custom_lang); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
    <!-- Page Heading -->
    <h1 class="h3 mb-2 text-gray-800"><a href="<?php echo e(route('admin.schedule.create')); ?>" class="btn btn-primary"><i class="fas fa-plus" aria-hidden="true"></i> <?php echo e($website_lang->where('lang_key','create')->first()->custom_lang); ?> </a></h1>
    <!-- DataTales Example -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary"><?php echo e($website_lang->where('lang_key','schedule_table')->first()->custom_lang); ?></h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th width="5%"><?php echo e($website_lang->where('lang_key','serial')->first()->custom_lang); ?></th>
                            <th width="15%"><?php echo e($website_lang->where('lang_key','lawyer')->first()->custom_lang); ?></th>
                            <th width="15%"><?php echo e($website_lang->where('lang_key','day')->first()->custom_lang); ?></th>
                            <th width="15%"><?php echo e($website_lang->where('lang_key','time')->first()->custom_lang); ?></th>
                            <th width="5%"><?php echo e($website_lang->where('lang_key','status')->first()->custom_lang); ?></th>
                            <th width="20%"><?php echo e($website_lang->where('lang_key','action')->first()->custom_lang); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $schedules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e(++$index); ?></td>
                            <td><?php echo e($item->lawyer->name); ?></td>
                            <td><?php echo e(ucfirst($item->day->day)); ?></td>
                            <td><?php echo e(strtoupper($item->start_time)); ?> - <?php echo e(strtoupper($item->end_time)); ?></td>
                            <td>
                                <?php if($item->status==1): ?>
                                <a href="" onclick="scheduleStatus(<?php echo e($item->id); ?>)"><input type="checkbox" checked data-toggle="toggle" data-on="Active" data-off="In-Active" data-onstyle="success" data-offstyle="danger"></a>
                                <?php else: ?>
                                    <a href="" onclick="scheduleStatus(<?php echo e($item->id); ?>)"><input type="checkbox" data-toggle="toggle" data-on="Active" data-off="In-Active" data-onstyle="success" data-offstyle="danger"></a>

                                <?php endif; ?>
                            </td>
                            <td>
                                <a href="<?php echo e(route('admin.schedule.edit',$item->id)); ?>" class="btn btn-primary btn-sm custom_danger_btn"><i class="fas fa-edit    "></i></a>
                                <?php
                                    $count=$appointments->where('schedule_id',$item->id)->count();
                                ?>
                                <?php if($count==0): ?>
                                <a data-toggle="modal" data-target="#deleteModal" href="javascript:;" onclick="deleteData(<?php echo e($item->id); ?>)" class="btn btn-danger btn-sm custom_danger_btn"><i class="fas fa-trash    "></i></a>
                                <?php endif; ?>



                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <script>
        function deleteData(id){
            $("#deleteForm").attr("action",'<?php echo e(url("admin/schedule/")); ?>'+"/"+id)
        }

        function scheduleStatus(id){
            // project demo mode check
         var isDemo="<?php echo e(env('PROJECT_MODE')); ?>"
         var demoNotify="<?php echo e(env('NOTIFY_TEXT')); ?>"
         if(isDemo==0){
             toastr.error(demoNotify);
             return;
         }
         // end
            $.ajax({
                type:"get",
                url:"<?php echo e(url('/admin/schedule-status/')); ?>"+"/"+id,
                success:function(response){
                   toastr.success(response)
                },
                error:function(err){
                    console.log(err);

                }
            })
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/penastud/public_html/law/resources/views/admin/schedule/index.blade.php ENDPATH**/ ?>