
<?php $__env->startSection('title'); ?>
<title><?php echo e($website_lang->where('lang_key','client')->first()->custom_lang); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
    <!-- DataTales Example -->
    <div class="row mb-2"">
        <div class="col-md-3">
            <div class="form-group">
                <label for=""><?php echo e($website_lang->where('lang_key','from')->first()->custom_lang); ?></label>
                <input type="text" class="form-control datepicker" id="from_date">
                <p class="invalid-feedback d-none" id="from_date_error"></p>
            </div>
        </div>
        <div class="col-md-3">
            <div class="form-group">
                <label for=""><?php echo e($website_lang->where('lang_key','to')->first()->custom_lang); ?></label>
                <input type="text" id="to_date" class="form-control datepicker">
            </div>
        </div>
        <div class="col-md-3 newsearch">
            <button type="button" id="searchPatient" class="btn btn-success"><?php echo e($website_lang->where('lang_key','search')->first()->custom_lang); ?></button>

        </div>
    </div>
    <div id="patient-box">
    <!-- DataTales Example -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary"><?php echo e($website_lang->where('lang_key','client_table')->first()->custom_lang); ?> <button class="btn btn-success btn-sm" onclick="printReport()"><i class="fas fa-print    "></i></button></h6>
        </div>
        <div class="card-body" id="search-appointment">
            <div class="table-responsive printArea">
                <table class="table table-bordered" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th width="5%"><?php echo e($website_lang->where('lang_key','serial')->first()->custom_lang); ?></th>
                            <th width="15%"><?php echo e($website_lang->where('lang_key','name')->first()->custom_lang); ?></th>
                            <th width="10%"><?php echo e($website_lang->where('lang_key','email')->first()->custom_lang); ?></th>
                            <th width="10%"><?php echo e($website_lang->where('lang_key','total_appointment')->first()->custom_lang); ?></th>
                            <th width="15%"><?php echo e($website_lang->where('lang_key','reg_date')->first()->custom_lang); ?></th>
                            <th width="15%"><?php echo e($website_lang->where('lang_key','status')->first()->custom_lang); ?></th>
                            <th width="10%"><?php echo e($website_lang->where('lang_key','action')->first()->custom_lang); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $clients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e(++$index); ?></td>
                            <td><?php echo e(ucfirst($item->name)); ?></td>
                            <td><?php echo e($item->email); ?></td>
                            <td><?php echo e($item->appointment->count()); ?></td>
                            <td><?php echo e($item->created_at->format('m-d-Y')); ?></td>


                            <td>
                                <?php if($item->status==1): ?>
                                    <a href="" onclick="clientStatus(<?php echo e($item->id); ?>)"><input type="checkbox" checked data-toggle="toggle" data-on="<?php echo e($website_lang->where('lang_key','active')->first()->custom_lang); ?>" data-off="<?php echo e($website_lang->where('lang_key','inactive')->first()->custom_lang); ?>" data-onstyle="success" data-offstyle="danger"></a>
                                <?php else: ?>
                                    <a href="" onclick="clientStatus(<?php echo e($item->id); ?>)"><input type="checkbox" data-toggle="toggle" data-on="<?php echo e($website_lang->where('lang_key','active')->first()->custom_lang); ?>" data-off="<?php echo e($website_lang->where('lang_key','inactive')->first()->custom_lang); ?>" data-onstyle="success" data-offstyle="danger"></a>

                                <?php endif; ?>
                            </td>
                            <td>
                                <a  href="<?php echo e(route('admin.client.show',$item->id)); ?>" class="btn btn-success btn-sm"><i class="fas fa-eye"></i></a>
                                <a data-toggle="modal" data-target="#delete-client-<?php echo e($item->id); ?>"  class="btn btn-danger btn-sm custom_danger_btn"><i class="fas fa-trash"></i></a>

                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

 <!-- Modal -->
 <?php $__currentLoopData = $clients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
 <div class="modal fade" id="delete-client-<?php echo e($item->id); ?>" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
     <div class="modal-dialog" role="document">
         <div class="modal-content">
                 <div class="modal-header">
                         <h5 class="modal-title"><?php echo e($website_lang->where('lang_key','delete_client')->first()->custom_lang); ?></h5>
                             <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                 <span aria-hidden="true">&times;</span>
                             </button>
                     </div>
             <div class="modal-body">
                 <div class="container-fluid">
                    <?php echo e($website_lang->where('lang_key','are_you_sure')->first()->custom_lang); ?>

                 </div>
             </div>
             <div class="modal-footer">
                 <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e($website_lang->where('lang_key','close')->first()->custom_lang); ?></button>
                 <a href="<?php echo e(route('admin.client.delete',$item->id)); ?>" class="btn btn-danger"><?php echo e($website_lang->where('lang_key','yes')->first()->custom_lang); ?></a>
             </div>
         </div>
     </div>
 </div>

<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <script>
	(function($) {

    "use strict";
        // remove prescribe medicine input field row
        $(document).on('click', '#searchPatient', function () {
           var from_date=$("#from_date").val();
           var doctor_id=$("#doctor_id").val();
           if(from_date){
               $('#from_date').removeClass('is-invalid')
               $('#from_date_error').addClass('d-none')
               var to_date=$("#to_date").val();
               if(to_date) to_date=to_date;
               else to_date=from_date;
               $.ajax({
                   type: 'GET',
                   url: "<?php echo e(route('admin.client.search')); ?>",
                   data:{from_date,to_date},
                   success: function (response) {
                       $('#patient-box').html(response)
                   },
                   error: function(err) {
                       console.log(err);
                   }
               });

           }else{
               toastr.error('From Date Is Required')
               $('#from_date').addClass('is-invalid')
               $('#from_date_error').text('From Date Is Required')
               $('#from_date_error').removeClass('d-none')
           }


       });
	   })(jQuery);

       function clientStatus(id){
           // project demo mode check
         var isDemo="<?php echo e(env('PROJECT_MODE')); ?>"
         var demoNotify="<?php echo e(env('NOTIFY_TEXT')); ?>"
         if(isDemo==0){
             toastr.error(demoNotify);
             return;
         }
         // end
            $.ajax({
                type:"get",
                url:"<?php echo e(url('/admin/client-status/')); ?>"+"/"+id,
                success:function(response){
                   toastr.success(response)
                },
                error:function(err){
                    console.log(err);

                }
            })
        }

   </script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/penastud/public_html/law/resources/views/admin/client/index.blade.php ENDPATH**/ ?>