
<?php $__env->startSection('title'); ?>
<title><?php echo e($lawyer->seo_title); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta'); ?>
<meta name="description" content="<?php echo e($lawyer->seo_description); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('client-content'); ?>

<!--Banner Start-->
<div class="banner-area flex" style="background-image:url(<?php echo e($banner->lawyer ? url($banner->lawyer) : ''); ?>);">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="banner-text">
                    <h1><?php echo e($lawyer->name); ?> (<?php echo e($lawyer->designations); ?>)</h1>
                    <ul>
                        <li><a href="<?php echo e(url('/')); ?>"><?php echo e($navigation->home); ?></a></li>
                        <li><span><?php echo e($lawyer->name); ?></span></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
<!--Banner End-->

<!--Team Detail Start-->
<div class="team-detail-page pt_40 pb_70">
    <div class="container">
        <div class="row">
            <div class="col-lg-4">
                <div class="team-detail-photo">
                    <img src="<?php echo e(url($lawyer->image)); ?>" alt="Team Photo">
                </div>
            </div>
            <div class="col-lg-8">
                <div class="team-detail-text">
                    <h4><?php echo e($lawyer->name); ?> </h4>
                    <span><b><?php echo e($lawyer->department->name); ?> (<?php echo e($lawyer->designations); ?>)</b></span>
                    <h5 class="appointment-cost"><?php echo e($website_lang->where('lang_key','appointment_fee')->first()->custom_lang); ?>: <?php echo e($currency->currency_icon); ?><?php echo e($lawyer->fee); ?></h5>

                    <?php echo clean($lawyer->about); ?>

                    <ul>
                        <?php if($lawyer->facebook): ?>
                        <li><a href="<?php echo e($lawyer->facebook); ?>"><i class="fab fa-facebook-f"></i></a></li>
                        <?php endif; ?>
                        <?php if($lawyer->twitter): ?>
                        <li><a href="<?php echo e($lawyer->twitter); ?>"><i class="fab fa-twitter"></i></a></li>
                        <?php endif; ?>
                        <?php if($lawyer->linkedin): ?>
                        <li><a href="<?php echo e($lawyer->linkedin); ?>"><i class="fab fa-linkedin"></i></a></li>
                        <?php endif; ?>
                    </ul>

                </div>
            </div>
        </div>
    </div>
</div>
<div class="team-exp-area bg-area pt_70 pb_70">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="team-headline">
                    <h2><?php echo e($website_lang->where('lang_key','lawyer_info')->first()->custom_lang); ?></h2>
                </div>
            </div>
            <div class="col-md-12">
                <!--Tab Start-->
                <div class="event-detail-tab mt_20">
                    <ul class="nav nav-tabs">
                        <li class="active">
                            <a class="active" href="#working_hour" data-toggle="tab"><?php echo e($website_lang->where('lang_key','working_hours')->first()->custom_lang); ?></a>
                        </li>
                        <li>
                            <a href="#address" data-toggle="tab"><?php echo e($website_lang->where('lang_key','address')->first()->custom_lang); ?></a>
                        </li>
                        <li>
                            <a href="#education" data-toggle="tab"><?php echo e($website_lang->where('lang_key','education')->first()->custom_lang); ?></a>
                        </li>
                        <li>
                            <a href="#experience" data-toggle="tab"><?php echo e($website_lang->where('lang_key','experience')->first()->custom_lang); ?></a>
                        </li>
                        <li>
                            <a href="#qualification" data-toggle="tab"><?php echo e($website_lang->where('lang_key','qualification')->first()->custom_lang); ?></a>
                        </li>
                        <li>
                            <a href="#book_appointment" data-toggle="tab"><?php echo e($website_lang->where('lang_key','appointment')->first()->custom_lang); ?></a>
                        </li>
                    </ul>
                </div>
                <div class="tab-content event-detail-content">
                    <div id="working_hour" class="tab-pane fade show active">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="wh-table table-responsive">
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th><?php echo e($website_lang->where('lang_key','week_day')->first()->custom_lang); ?></th>
                                                <th><?php echo e($website_lang->where('lang_key','schedule')->first()->custom_lang); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                                $old_day_id=0;
                                            ?>
                                            <?php $__currentLoopData = $lawyer->schedules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $schedule): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($old_day_id != $schedule->day_id): ?>
                                            <tr>
                                                <td><?php echo e($schedule->day->custom_day); ?></td>
                                                <td>
                                                    <?php
                                                        $times=$lawyer->schedules->where('day_id',$schedule->day_id);
                                                    ?>
                                                    <?php $__currentLoopData = $times; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $time): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="sch"><?php echo e(strtoupper($time->start_time)); ?> - <?php echo e(strtoupper($time->end_time)); ?></div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                </td>
                                            </tr>
                                            <?php endif; ?>
                                            <?php
                                                $old_day_id=$schedule->day_id;
                                            ?>


                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div id="address" class="tab-pane fade">
                        <div class="row">
                            <div class="col-md-12">
                                <?php echo clean($lawyer->address); ?>


                            </div>
                        </div>
                    </div>
                    <div id="education" class="tab-pane fade">
                        <div class="row">
                            <div class="col-md-12">
                                <?php echo clean($lawyer->educations); ?>

                            </div>
                        </div>
                    </div>
                    <div id="experience" class="tab-pane fade">
                        <div class="row">
                            <div class="col-md-12">
                                <?php echo clean($lawyer->experience); ?>

                            </div>
                        </div>
                    </div>
                    <div id="qualification" class="tab-pane fade">
                        <div class="row">
                            <div class="col-md-12">
                                <?php echo clean($lawyer->qualifications); ?>

                            </div>
                        </div>
                    </div>
                    <div id="book_appointment" class="tab-pane fade">
                        <div class="row">
                            <div class="col-md-12">
                                <h3><?php echo e($website_lang->where('lang_key','create_appointment')->first()->custom_lang); ?></h3>

                                <div class="book-appointment">

                                    <form action="<?php echo e(url('create-appointment')); ?>" method="POST" >
                                        <?php echo csrf_field(); ?>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label for="" class="form-label"><?php echo e($website_lang->where('lang_key','select_date')->first()->custom_lang); ?></label>
                                                    <input type="text" name="date" class="form-control datepicker" id="datepicker-value">
                                                    <input type="hidden" name="lawyer_id" value="<?php echo e($lawyer->id); ?>" id="lawyer_id">
                                                    <input type="hidden" value="<?php echo e($lawyer->department_id); ?>" name="department_id">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row d-none" id="schedule-box-outer">
                                            <div class="col-md-6">
                                                <div class="mb-3" >
                                                    <label for="" class="form-label"><?php echo e($website_lang->where('lang_key','select_schedule')->first()->custom_lang); ?></label>
                                                    <select name="schedule_id" class="form-control" id="doctor-available-schedule">

                                                    </select>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-6 d-none" id="doctor-schedule-error">

                                            </div>
                                        </div>



                                        <div class="mb-3">
                                            <button type="submit" class="btn btn-primary mb-3" id="sub" disabled><?php echo e($website_lang->where('lang_key','submit')->first()->custom_lang); ?></button>
                                        </div>
                                    </form>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
                <!--Tab End-->
            </div>

        </div>
    </div>
</div>
<!--Team Detail End-->


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.client.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/penastud/public_html/law/resources/views/client/lawyer/show.blade.php ENDPATH**/ ?>