<?php echo $__env->make('layouts.admin.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<body id="page-top">

    <!-- Page Wrapper -->
    <div id="wrapper">

        <!-- Sidebar -->
        <ul class="navbar-nav bg-gradient-primary sidebar sidebar-dark accordion" id="accordionSidebar">

            <?php
                $setting=App\Setting::first();
                $website_lang=App\ManageText::all();
            ?>
            <!-- Sidebar - Brand -->
            <a class="sidebar-brand d-flex align-items-center justify-content-center" href="<?php echo e(route('home')); ?>">
                <div class="sidebar-brand-icon rotate-n-15">
                    <i class="<?php echo e($setting->sidebar_header_icon); ?>"></i>
                </div>
                <div class="sidebar-brand-text mx-3"><?php echo e($setting->sidebar_header_name); ?></div>
            </a>

            <!-- Divider -->
            <hr class="sidebar-divider my-0">

            <!-- Nav Item - Dashboard -->
            <li class="nav-item <?php echo e(Route::is('lawyer.dashboard')?'active':''); ?>">
                <a class="nav-link" href="<?php echo e(route('lawyer.dashboard')); ?>">
                    <i class="fas fa-fw fa-tachometer-alt"></i>
                    <span><?php echo e($website_lang->where('lang_key','dashboard')->first()->custom_lang); ?></span></a>
            </li>


            <!-- Divider -->
            <hr class="sidebar-divider">

            <!-- Heading -->
            <div class="sidebar-heading">
                <?php echo e($website_lang->where('lang_key','interface')->first()->custom_lang); ?>

            </div>

            <!-- Nav Item - Charts -->
            <li class="nav-item <?php echo e(Route::is('lawyer.today.appointment') || Route::is('lawyer.meet') || Route::is('lawyer.edit-prescription') ?'active':''); ?>">
                <a class="nav-link" href="<?php echo e(route('lawyer.today.appointment')); ?>">
                    <i class="fas fa-fw fa-chart-area"></i>
                    <span><?php echo e($website_lang->where('lang_key','today_appointment')->first()->custom_lang); ?></span></a>
            </li>
             <!-- Nav Item - Pages Collapse Menu -->
             <li class="nav-item">
                <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapsePages"
                    aria-expanded="true" aria-controls="collapsePages">
                    <i class="fas fa-fw fa-folder"></i>
                    <span><?php echo e($website_lang->where('lang_key','manage_appointment')->first()->custom_lang); ?></span>
                </a>
                <div id="collapsePages" class="collapse <?php echo e(Route::is('lawyer.new.appointment') || Route::is('lawyer.all.appointment') || Route::is('lawyer.already.treatment') || Route::is('lawyer.already-meet') ?'show':''); ?>" aria-labelledby="headingPages" data-parent="#accordionSidebar">
                    <div class="bg-white py-2 collapse-inner rounded">
                        <a class="collapse-item <?php echo e(Route::is('lawyer.new.appointment')?'active':''); ?>" href="<?php echo e(route('lawyer.new.appointment')); ?>"><?php echo e($website_lang->where('lang_key','new_appointment')->first()->custom_lang); ?></a>
                        <a class="collapse-item <?php echo e(Route::is('lawyer.all.appointment') || Route::is('lawyer.already-meet') ?'active':''); ?>" href="<?php echo e(route('lawyer.all.appointment')); ?>"><?php echo e($website_lang->where('lang_key','appointment_history')->first()->custom_lang); ?></a>


                    </div>
                </div>
            </li>


            <!-- Nav Item - Pages Collapse Menu -->
            <li class="nav-item">
                <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#live-consultant"
                    aria-expanded="true" aria-controls="live-consultant">
                    <i class="fas fa-fw fa-folder"></i>
                    <span><?php echo e($website_lang->where('lang_key','live_consult')->first()->custom_lang); ?></span>
                </a>
                <div id="live-consultant" class="collapse <?php echo e(Route::is('lawyer.zoom-credential') || Route::is('lawyer.zoom-meetings') || Route::is('lawyer.create-zoom-meeting') || Route::is('lawyer.edit-zoom-meeting') || Route::is('lawyer.upcomming-meeting') || Route::is('lawyer.meeting-history') ? 'show':''); ?>" aria-labelledby="headingPages" data-parent="#accordionSidebar">
                    <div class="bg-white py-2 collapse-inner rounded">
                        <a class="collapse-item <?php echo e(Route::is('lawyer.zoom-meetings') || Route::is('lawyer.create-zoom-meeting') || Route::is('lawyer.edit-zoom-meeting')?'active':''); ?>" href="<?php echo e(route('lawyer.zoom-meetings')); ?>"><?php echo e($website_lang->where('lang_key','meeting')->first()->custom_lang); ?></a>

                        <a class="collapse-item <?php echo e(Route::is('lawyer.meeting-history') ?'active':''); ?>" href="<?php echo e(route('lawyer.meeting-history')); ?>"><?php echo e($website_lang->where('lang_key','meeting_history')->first()->custom_lang); ?></a>
                        <a class="collapse-item <?php echo e(Route::is('lawyer.upcomming-meeting') ?'active':''); ?>" href="<?php echo e(route('lawyer.upcomming-meeting')); ?>"><?php echo e($website_lang->where('lang_key','upcoming_meeting')->first()->custom_lang); ?></a>


                        <a class="collapse-item <?php echo e(Route::is('lawyer.zoom-credential')?'active':''); ?>" href="<?php echo e(route('lawyer.zoom-credential')); ?>"><?php echo e($website_lang->where('lang_key','setting')->first()->custom_lang); ?></a>


                    </div>
                </div>
            </li>

             <!-- Nav Item - Charts -->
            <li class="nav-item <?php echo e(Route::is('lawyer.leave.index')?'active':''); ?>">
                <a class="nav-link" href="<?php echo e(route('lawyer.leave.index')); ?>">
                    <i class="fas fa-fw fa-chart-area"></i>
                    <span><?php echo e($website_lang->where('lang_key','manage_leave')->first()->custom_lang); ?></span></a>
            </li>

             <!-- Nav Item - Charts -->
            <li class="nav-item <?php echo e(Route::is('lawyer.payment.history')?'active':''); ?>">
                <a class="nav-link" href="<?php echo e(route('lawyer.payment.history')); ?>">
                    <i class="fas fa-fw fa-chart-area"></i>
                    <span><?php echo e($website_lang->where('lang_key','payment_history')->first()->custom_lang); ?></span></a>
            </li>
             <!-- Nav Item - Charts -->
            <li class="nav-item <?php echo e(Route::is('lawyer.schedule')?'active':''); ?>">
                <a class="nav-link" href="<?php echo e(route('lawyer.schedule')); ?>">
                    <i class="fas fa-fw fa-chart-area"></i>
                    <span><?php echo e($website_lang->where('lang_key','my_schedule')->first()->custom_lang); ?></span></a>
            </li>

             <!-- Nav Item - Charts -->
            <li class="nav-item">
                <a class="nav-link" href="<?php echo e(route('lawyer.message.index')); ?>">
                    <i class="fas fa-fw fa-chart-area"></i>
                    <span><?php echo e($website_lang->where('lang_key','message')->first()->custom_lang); ?></span></a>
            </li>




            <!-- Divider -->
            <hr class="sidebar-divider d-none d-md-block">

            <!-- Sidebar Toggler (Sidebar) -->
            <div class="text-center d-none d-md-inline">
                <button class="rounded-circle border-0" id="sidebarToggle"></button>
            </div>

        </ul>
        <!-- End of Sidebar -->

        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column">

            <!-- Main Content -->
            <div id="content">

                <!-- Topbar -->
                <nav class="navbar navbar-expand navbar-light bg-white topbar mb-4 static-top shadow">

                    <!-- Sidebar Toggle (Topbar) -->
                    <button id="sidebarToggleTop" class="btn btn-link d-md-none rounded-circle mr-3">
                        <i class="fas fa-bars"></i>
                    </button>
                    <!-- Topbar Navbar -->
                    <ul class="navbar-nav ml-auto">

                        <!-- Nav Item - Search Dropdown (Visible Only XS) -->
                        <li class="nav-item dropdown no-arrow d-sm-none">
                            <a class="nav-link dropdown-toggle" href="#" id="searchDropdown" role="button"
                                data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fas fa-search fa-fw"></i>
                            </a>
                            <!-- Dropdown - Messages -->
                            <div class="dropdown-menu dropdown-menu-right p-3 shadow animated--grow-in"
                                aria-labelledby="searchDropdown">
                                <form class="form-inline mr-auto w-100 navbar-search">
                                    <div class="input-group">
                                        <input type="text" class="form-control bg-light border-0 small"
                                            placeholder="Search for..." aria-label="Search"
                                            aria-describedby="basic-addon2">
                                        <div class="input-group-append">
                                            <button class="btn btn-primary" type="button">
                                                <i class="fas fa-search fa-sm"></i>
                                            </button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </li>


                        <div class="topbar-divider d-none d-sm-block"></div>

                        <!-- Nav Item - User Information -->
                        <li class="nav-item dropdown no-arrow">
                            <a class="nav-link dropdown-toggle" href="#" id="userDropdown" role="button"
                                data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <?php
                                    $doctorInfo=Auth::guard('lawyer')->user();
                                ?>
                                <span class="mr-2 d-none d-lg-inline text-gray-600 small"><?php echo e(ucfirst($doctorInfo->name)); ?></span>
                                <?php if($doctorInfo->image): ?>
                                    <img class="img-profile rounded-circle"
                                    src="<?php echo e(url($doctorInfo->image)); ?>">
                                <?php else: ?>
                                    <img class="img-profile rounded-circle"
                                    src="<?php echo e(url('default-user.jpg')); ?>">
                                <?php endif; ?>

                            </a>
                            <!-- Dropdown - User Information -->
                            <div class="dropdown-menu dropdown-menu-right shadow animated--grow-in"
                                aria-labelledby="userDropdown">
                                <a class="dropdown-item" href="<?php echo e(route('lawyer.profile')); ?>">
                                    <i class="fas fa-user fa-sm fa-fw mr-2 text-gray-400"></i>
                                    <?php echo e($website_lang->where('lang_key','profile')->first()->custom_lang); ?>

                                </a>
                                <div class="dropdown-divider"></div>
                                <a class="dropdown-item" href="<?php echo e(route('lawyer.logout')); ?>">
                                    <i class="fas fa-sign-out-alt fa-sm fa-fw mr-2 text-gray-400"></i>
                                    <?php echo e($website_lang->where('lang_key','logout')->first()->custom_lang); ?>

                                </a>
                            </div>
                        </li>

                    </ul>

                </nav>
                <!-- End of Topbar -->

                <!-- Begin Page Content -->
                <div class="container-fluid">

                   <?php echo $__env->yieldContent('lawyer-content'); ?>

                </div>
                <!-- /.container-fluid -->

            </div>
            <!-- End of Main Content -->



        </div>
        <!-- End of Content Wrapper -->

    </div>
    <!-- End of Page Wrapper -->

    <!-- Scroll to Top Button-->
    <a class="scroll-to-top rounded" href="#page-top">
        <i class="fas fa-angle-up"></i>
    </a>


<?php echo $__env->make('layouts.admin.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /home/penastud/public_html/law/resources/views/layouts/lawyer/layout.blade.php ENDPATH**/ ?>