
<?php $__env->startSection('title'); ?>
<title><?php echo e($website_lang->where('lang_key','lawyer')->first()->custom_lang); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
    <!-- Page Heading -->
    <h1 class="h3 mb-2 text-gray-800"><a href="<?php echo e(route('admin.lawyer.index')); ?>" class="btn btn-primary"><i class="fas fa-list" aria-hidden="true"></i> <?php echo e($website_lang->where('lang_key','all_lawyer')->first()->custom_lang); ?> </a></h1>
    <!-- DataTales Example -->
    <div class="row">
        <div class="col-md-12">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary"><?php echo e($website_lang->where('lang_key','lawyer_form')->first()->custom_lang); ?></h6>
                </div>
                <div class="card-body">

                    <form action="<?php echo e(route('admin.lawyer.update',$lawyer->id)); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('patch'); ?>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="name"><?php echo e($website_lang->where('lang_key','name')->first()->custom_lang); ?> *</label>
                                    <input type="text" name="name" class="form-control" id="name" value="<?php echo e($lawyer->name); ?>">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="email"><?php echo e($website_lang->where('lang_key','email')->first()->custom_lang); ?> *</label>
                                    <input type="text" name="email" class="form-control" id="email" value="<?php echo e($lawyer->email); ?>">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="phone"><?php echo e($website_lang->where('lang_key','phone')->first()->custom_lang); ?> *</label>
                                    <input type="text" name="phone" class="form-control" id="phone" value="<?php echo e($lawyer->phone); ?>">
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="designations"><?php echo e($website_lang->where('lang_key','designation')->first()->custom_lang); ?> *</label>
                                    <input type="text" name="designations" class="form-control" id="designations" value="<?php echo e($lawyer->designations); ?>">
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="image"><?php echo e($website_lang->where('lang_key','image')->first()->custom_lang); ?></label>
                                    <input type="file" name="image" class="form-control" id="image" >
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="image"><?php echo e($website_lang->where('lang_key','exist_image')->first()->custom_lang); ?></label>
                                    <img src="<?php echo e(url($lawyer->image)); ?>" alt="doctor image" width="120px">
                                </div>
                            </div>


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="appointment_fee"><?php echo e($website_lang->where('lang_key','appointment_fee')->first()->custom_lang); ?> *</label>
                                    <input type="text" name="appointment_fee" class="form-control" id="appointment_fee"  value="<?php echo e($lawyer->fee); ?>">
                                </div>
                            </div>




                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="department"><?php echo e($website_lang->where('lang_key','department')->first()->custom_lang); ?> *</label>
                                    <select name="department" id="department" class="form-control">
                                        <option value=""><?php echo e($website_lang->where('lang_key','select_department')->first()->custom_lang); ?></option>
                                        <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option <?php echo e($lawyer->department_id==$item->id? 'selected' : ''); ?> value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="location"><?php echo e($website_lang->where('lang_key','location')->first()->custom_lang); ?> *</label>
                                    <select name="location" id="location" class="form-control">
                                        <option value=""><?php echo e($website_lang->where('lang_key','select_location')->first()->custom_lang); ?></option>
                                        <?php $__currentLoopData = $locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option <?php echo e($lawyer->location_id==$item->id? 'selected' : ''); ?> value="<?php echo e($item->id); ?>"><?php echo e($item->location); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="facebook"><?php echo e($website_lang->where('lang_key','facebook')->first()->custom_lang); ?></label>
                                    <input type="text" class="form-control" name="facebook" id="facebook" value="<?php echo e($lawyer->facebook); ?>">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="twitter"><?php echo e($website_lang->where('lang_key','twitter')->first()->custom_lang); ?></label>
                                    <input type="text" class="form-control" name="twitter" id="twitter" value="<?php echo e($lawyer->twitter); ?>">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="linkedin"><?php echo e($website_lang->where('lang_key','linkedin')->first()->custom_lang); ?></label>
                                    <input type="text" class="form-control" name="linkedin" id="linkedin" value="<?php echo e($lawyer->linkedin); ?>">
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="about"><?php echo e($website_lang->where('lang_key','about')->first()->custom_lang); ?></label>
                                    <textarea name="about" id="about" cols="30" rows="5" class="form-control"><?php echo e($lawyer->about); ?></textarea>
                                </div>
                            </div>



                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="address"><?php echo e($website_lang->where('lang_key','address')->first()->custom_lang); ?></label>
                                    <textarea name="address" id="address" class="summernote"><?php echo e($lawyer->address); ?></textarea>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="educations"><?php echo e($website_lang->where('lang_key','education')->first()->custom_lang); ?></label>
                                    <textarea name="educations" id="educations" class="summernote"><?php echo e($lawyer->educations); ?></textarea>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="experiences"><?php echo e($website_lang->where('lang_key','experience')->first()->custom_lang); ?></label>
                                    <textarea name="experiences" id="experiences" class="summernote"><?php echo e($lawyer->experience); ?></textarea>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="qualifications"><?php echo e($website_lang->where('lang_key','qualification')->first()->custom_lang); ?></label>
                                    <textarea name="qualifications" id="qualifications" class="summernote"><?php echo e($lawyer->qualifications); ?></textarea>
                                </div>
                            </div>



                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="status"><?php echo e($website_lang->where('lang_key','status')->first()->custom_lang); ?> *</label>
                                    <select name="status" id="status" class="form-control">
                                        <option <?php echo e($lawyer->status==1 ? 'selected':''); ?> value="1"><?php echo e($website_lang->where('lang_key','active')->first()->custom_lang); ?></option>
                                        <option <?php echo e($lawyer->status==0 ? 'selected':''); ?> value="0"><?php echo e($website_lang->where('lang_key','inactive')->first()->custom_lang); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="show_homepage"><?php echo e($website_lang->where('lang_key','show_homepage')->first()->custom_lang); ?> *</label>
                                    <select name="show_homepage" id="show_homepage" class="form-control">
                                        <option <?php echo e($lawyer->show_homepage==0 ? 'selected':''); ?> value="0"><?php echo e($website_lang->where('lang_key','no')->first()->custom_lang); ?></option>
                                        <option <?php echo e($lawyer->show_homepage==1 ? 'selected':''); ?>  value="1"><?php echo e($website_lang->where('lang_key','yes')->first()->custom_lang); ?></option>
                                    </select>
                                </div>
                            </div>

                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="seo_title"><?php echo e($website_lang->where('lang_key','seo_title')->first()->custom_lang); ?></label>
                                    <input type="text" name="seo_title" class="form-control" id="seo_title" value="<?php echo e($lawyer->seo_title); ?>">
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="seo_description"><?php echo e($website_lang->where('lang_key','seo_description')->first()->custom_lang); ?></label>
                                    <textarea name="seo_description" id="seo_description" cols="30" rows="3" class="form-control" ><?php echo e($lawyer->seo_description); ?></textarea>
                                </div>
                            </div>
                        </div>


                        <button type="submit" class="btn btn-success"><?php echo e($website_lang->where('lang_key','update')->first()->custom_lang); ?></button>
                    </form>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/penastud/public_html/law/resources/views/admin/lawyer/edit.blade.php ENDPATH**/ ?>