
<?php $__env->startSection('title'); ?>
<title><?php echo e($website_lang->where('lang_key','feature')->first()->custom_lang); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
    <!-- Page Heading -->
    <h1 class="h3 mb-2 text-gray-800"><a href="#" data-toggle="modal" data-target="#createFeature" class="btn btn-primary"><i class="fas fa-plus" aria-hidden="true"></i> <?php echo e($website_lang->where('lang_key','create')->first()->custom_lang); ?> </a></h1>
    <!-- DataTales Example -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary"><?php echo e($website_lang->where('lang_key','feature_table')->first()->custom_lang); ?></h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th width="5%"><?php echo e($website_lang->where('lang_key','serial')->first()->custom_lang); ?></th>
                            <th width="20%"><?php echo e($website_lang->where('lang_key','title')->first()->custom_lang); ?></th>
                            <th width="30%"><?php echo e($website_lang->where('lang_key','description')->first()->custom_lang); ?></th>
                            <th width="15%"><?php echo e($website_lang->where('lang_key','image')->first()->custom_lang); ?></th>
                            <th width="10%"><?php echo e($website_lang->where('lang_key','logo')->first()->custom_lang); ?></th>
                            <th width="5%"><?php echo e($website_lang->where('lang_key','status')->first()->custom_lang); ?></th>
                            <th width="15%"><?php echo e($website_lang->where('lang_key','action')->first()->custom_lang); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e(++$index); ?></td>
                            <td><?php echo e($item->title); ?></td>
                            <td><?php echo e($item->description); ?></td>
                            <td><img src="<?php echo e(url($item->background_image)); ?>" alt="" class="w_200"></td>
                            <td><i class="<?php echo e($item->logo); ?> fz_40"></i></td>
                            <td>
                                <?php if($item->status==1): ?>
                                <a href="" onclick="featureStatus(<?php echo e($item->id); ?>)"><input type="checkbox" checked data-toggle="toggle" data-on="<?php echo e($website_lang->where('lang_key','active')->first()->custom_lang); ?>" data-off="<?php echo e($website_lang->where('lang_key','inactive')->first()->custom_lang); ?>" data-onstyle="success" data-offstyle="danger"></a>
                                <?php else: ?>
                                    <a href="" onclick="featureStatus(<?php echo e($item->id); ?>)"><input type="checkbox" data-toggle="toggle" data-on="<?php echo e($website_lang->where('lang_key','active')->first()->custom_lang); ?>" data-off="<?php echo e($website_lang->where('lang_key','inactive')->first()->custom_lang); ?>" data-onstyle="success" data-offstyle="danger"></a>

                                <?php endif; ?>
                            </td>
                            <td>
                                <a href="#" data-toggle="modal" data-target="#updateFeature-<?php echo e($item->id); ?>" class="btn btn-primary btn-sm"><i class="fas fa-edit  "></i></a>
                                <a data-toggle="modal" data-target="#deleteModal" href="javascript:;" onclick="deleteData(<?php echo e($item->id); ?>)" class="btn btn-danger btn-sm"><i class="fas fa-trash"></i></a>


                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- create feature Modal -->
    <div class="modal fade" id="createFeature" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                    <div class="modal-header">
                            <h5 class="modal-title"><?php echo e($website_lang->where('lang_key','feature_form')->first()->custom_lang); ?></h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                        </div>
                <div class="modal-body">
                    <div class="container-fluid">

                    <form action="<?php echo e(route('admin.feature.store')); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="form-group">
                            <label for="title"><?php echo e($website_lang->where('lang_key','title')->first()->custom_lang); ?></label>
                            <input type="text" name="title" class="form-control" id="title" >
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="image"><?php echo e($website_lang->where('lang_key','image')->first()->custom_lang); ?></label>
                                    <input type="file" class="form-control" name="background_image" id="image">
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="logo"><?php echo e($website_lang->where('lang_key','logo')->first()->custom_lang); ?></label>
                                    <input type="text" class="form-control custom-icon-picker" name="logo" id="logo" placeholder='fas fa-edit'>
                                </div>
                            </div>

                        </div>
                        <div class="form-group">
                            <label for="description"><?php echo e($website_lang->where('lang_key','short_des')->first()->custom_lang); ?></label>
                            <textarea name="description" id="description" cols="30" rows="5" class="form-control"></textarea>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="status"><?php echo e($website_lang->where('lang_key','status')->first()->custom_lang); ?></label>
                                    <select name="status" id="status" class="form-control">
                                        <option value="1"><?php echo e($website_lang->where('lang_key','active')->first()->custom_lang); ?></option>
                                        <option value="0"><?php echo e($website_lang->where('lang_key','inactive')->first()->custom_lang); ?></option>
                                    </select>
                                </div>
                            </div>
                        </div>


                        <button type="button" class="btn btn-danger" data-dismiss="modal"><?php echo e($website_lang->where('lang_key','close')->first()->custom_lang); ?></button>
                        <button type="submit" class="btn btn-success"><?php echo e($website_lang->where('lang_key','save')->first()->custom_lang); ?></button>
                    </form>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <!-- create feature Modal -->
    <?php $__currentLoopData = $features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="modal fade" id="updateFeature-<?php echo e($item->id); ?>" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                        <div class="modal-header">
                                <h5 class="modal-title"><?php echo e($website_lang->where('lang_key','feature_form')->first()->custom_lang); ?></h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                            </div>
                    <div class="modal-body">
                        <div class="container-fluid">

                        <form action="<?php echo e(route('admin.feature.update',$item->id)); ?>" method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('patch'); ?>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="title"><?php echo e($website_lang->where('lang_key','title')->first()->custom_lang); ?></label>
                                        <input type="text" name="title" class="form-control" id="title" value="<?php echo e($item->title); ?>">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="logo"><?php echo e($website_lang->where('lang_key','logo')->first()->custom_lang); ?></label>
                                        <input type="text" class="form-control custom-icon-picker" name="logo" id="logo" value="<?php echo e($item->logo); ?>">
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="image"><?php echo e($website_lang->where('lang_key','image')->first()->custom_lang); ?></label>
                                        <input type="file" class="form-control" name="background_image" id="image">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="image"><?php echo e($website_lang->where('lang_key','exist_image')->first()->custom_lang); ?></label>
                                        <img src="<?php echo e(url($item->background_image)); ?>" alt="backgroud image" width="120px">
                                    </div>
                                </div>



                            </div>
                            <div class="form-group">
                                <label for="description"><?php echo e($website_lang->where('lang_key','short_des')->first()->custom_lang); ?></label>
                                <textarea name="description" id="description" cols="30" rows="5" class="form-control"><?php echo e($item->description); ?></textarea>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="status"><?php echo e($website_lang->where('lang_key','status')->first()->custom_lang); ?></label>
                                        <select name="status" id="status" class="form-control">
                                            <option <?php echo e($item->status==1 ? 'selected' : ''); ?> value="1"><?php echo e($website_lang->where('lang_key','active')->first()->custom_lang); ?></option>
                                            <option <?php echo e($item->status==0 ? 'selected' : ''); ?> value="0"><?php echo e($website_lang->where('lang_key','inactive')->first()->custom_lang); ?></option>
                                        </select>
                                    </div>
                                </div>
                            </div>


                            <button type="button" class="btn btn-danger" data-dismiss="modal"><?php echo e($website_lang->where('lang_key','close')->first()->custom_lang); ?></button>
                            <button type="submit" class="btn btn-success"><?php echo e($website_lang->where('lang_key','update')->first()->custom_lang); ?></button>
                        </form>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



    <script>
        function deleteData(id){
            $("#deleteForm").attr("action",'<?php echo e(url("admin/feature/")); ?>'+"/"+id)
        }

        function featureStatus(id){

// project demo mode check
         var isDemo="<?php echo e(env('PROJECT_MODE')); ?>"
         var demoNotify="<?php echo e(env('NOTIFY_TEXT')); ?>"
         if(isDemo==0){
             toastr.error(demoNotify);
             return;
         }
         // end
            $.ajax({
                type:"get",
                url:"<?php echo e(url('/admin/feature-status/')); ?>"+"/"+id,
                success:function(response){
                   toastr.success(response)
                },
                error:function(err){
                    console.log(err);

                }
            })
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/penastud/public_html/law/resources/views/admin/feature/index.blade.php ENDPATH**/ ?>